/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.at4j.archive.ArchiveSymbolicLinkEntry;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntry;
import org.at4j.zip.ZipEntryCentralFileHeaderData;
import org.at4j.zip.ZipEntryCollaborator;
import org.at4j.zip.ZipEntryLocalFileHeaderData;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.entityfs.el.EntityLocation;
import org.entityfs.el.EntityLocations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipSymbolicLinkEntry
extends ZipEntry
implements ArchiveSymbolicLinkEntry<ZipEntry, ZipDirectoryEntry> {
    private final EntityLocation<?> m_target;
    private final UnsignedInteger m_crc32;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipSymbolicLinkEntry(ZipEntryCollaborator zipEntryCollaborator, ZipEntryCentralFileHeaderData zipEntryCentralFileHeaderData, ZipEntryLocalFileHeaderData zipEntryLocalFileHeaderData, Charset charset) {
        super(zipEntryCollaborator, zipEntryCentralFileHeaderData, zipEntryLocalFileHeaderData);
        ZipEntryCompressionMethod zipEntryCompressionMethod = zipEntryCentralFileHeaderData.getCompressionMethod();
        try {
            InputStream inputStream = zipEntryCompressionMethod.createInputStream(this.getCollaborator().openStream(zipEntryLocalFileHeaderData.getStartPositionOfFileData(), zipEntryLocalFileHeaderData.getStartPositionOfFileData() + zipEntryCentralFileHeaderData.getCompressedSize().longValue() - 1L), zipEntryCentralFileHeaderData.getCompressedSize().longValue(), zipEntryCentralFileHeaderData.getUncompressedSize().longValue());
            try {
                int n = (int)zipEntryCentralFileHeaderData.getUncompressedSize().longValue();
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
                }
                this.m_target = EntityLocations.parseLocation((String)charset.decode(ByteBuffer.wrap(byArray)).toString());
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ZipFileParseException(iOException);
        }
        this.m_crc32 = zipEntryCentralFileHeaderData.getCrc32();
    }

    @Override
    public EntityLocation<?> getLinkTarget() {
        return this.m_target;
    }

    public UnsignedInteger getCrc32() {
        return this.m_crc32;
    }

    public String toString() {
        return this.getName() + " (l)";
    }
}

