/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip;

import java.util.HashMap;
import java.util.Map;
import org.at4j.support.lang.UnsignedByte;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ZipVersionMadeBy {
    MSDOS("MS-DOS, OS/2", 0),
    AMIGA("amiga", 1),
    OPENVMS("OpenVMS", 2),
    UNIX("Unix", 3),
    VMCMS("VM/CMS", 4),
    ATARI_ST("Atari ST", 5),
    OS2_HPFS("OS/2 HPFS", 6),
    MACINTOSH("Macintosh", 7),
    Z_SYSTEM("Z-System", 8),
    CPM("CP/M", 9),
    WINDOWS_NTFS("Windows NTFS", 11),
    SMS_QDOS("SMS/QDOS", 12),
    ACORN_RISC("Acorn RISC", 13),
    VFAT("VFAT", 14),
    ALT_MVS("Alternate MVS", 15),
    BEOS("BeOS", 16),
    TANDEM("Tandem", 17),
    THEOS("THEOS", 18),
    OSX("OS X", 19),
    ATHEOS("AtheOS/Syllable", 30);

    private static final Map<UnsignedByte, ZipVersionMadeBy> CODE_MAP;
    private final String m_tag;
    private final UnsignedByte m_code;

    private ZipVersionMadeBy(String string2, int n2) {
        this.m_tag = string2;
        this.m_code = UnsignedByte.valueOf(n2);
    }

    public UnsignedByte getCode() {
        return this.m_code;
    }

    public static ZipVersionMadeBy valueOf(UnsignedByte unsignedByte) throws IllegalArgumentException {
        ZipVersionMadeBy zipVersionMadeBy = CODE_MAP.get(unsignedByte);
        if (zipVersionMadeBy == null) {
            throw new IllegalArgumentException("Unknown Zip version made by code " + unsignedByte);
        }
        return zipVersionMadeBy;
    }

    public String toString() {
        return this.m_tag;
    }

    static {
        CODE_MAP = new HashMap<UnsignedByte, ZipVersionMadeBy>(19);
        CODE_MAP.put(MSDOS.getCode(), MSDOS);
        CODE_MAP.put(AMIGA.getCode(), AMIGA);
        CODE_MAP.put(OPENVMS.getCode(), OPENVMS);
        CODE_MAP.put(UNIX.getCode(), UNIX);
        CODE_MAP.put(VMCMS.getCode(), VMCMS);
        CODE_MAP.put(ATARI_ST.getCode(), ATARI_ST);
        CODE_MAP.put(OS2_HPFS.getCode(), OS2_HPFS);
        CODE_MAP.put(MACINTOSH.getCode(), MACINTOSH);
        CODE_MAP.put(Z_SYSTEM.getCode(), Z_SYSTEM);
        CODE_MAP.put(CPM.getCode(), CPM);
        CODE_MAP.put(WINDOWS_NTFS.getCode(), WINDOWS_NTFS);
        CODE_MAP.put(SMS_QDOS.getCode(), SMS_QDOS);
        CODE_MAP.put(ACORN_RISC.getCode(), ACORN_RISC);
        CODE_MAP.put(VFAT.getCode(), VFAT);
        CODE_MAP.put(ALT_MVS.getCode(), ALT_MVS);
        CODE_MAP.put(BEOS.getCode(), BEOS);
        CODE_MAP.put(TANDEM.getCode(), TANDEM);
        CODE_MAP.put(THEOS.getCode(), THEOS);
        CODE_MAP.put(OSX.getCode(), OSX);
        CODE_MAP.put(ATHEOS.getCode(), ATHEOS);
    }
}

