/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.at4j.zip.builder.FileWriteResult;
import org.at4j.zip.builder.FileWriteStrategy;
import org.at4j.zip.builder.ZipEntrySettings;
import org.at4j.zip.comp.StoredCompressionMethod;
import org.entityfs.RandomAccess;
import org.entityfs.ReadableFile;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.ChecksumInputStream;
import org.entityfs.support.io.CountingOutputStream;
import org.entityfs.support.io.StreamUtil;
import org.entityfs.util.io.RandomAccessToOutputStreamAdapter;

final class RereadableFileWriteStrategy
implements FileWriteStrategy {
    private final ReadableFile m_file;
    private final ZipEntrySettings m_effectiveSettings;

    public RereadableFileWriteStrategy(ReadableFile readableFile, ZipEntrySettings zipEntrySettings) {
        readableFile.getClass();
        zipEntrySettings.getClass();
        this.m_file = readableFile;
        this.m_effectiveSettings = zipEntrySettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWriteResult writeFile(RandomAccess randomAccess) throws IOException {
        long l;
        long l2;
        CountingOutputStream countingOutputStream;
        long l3 = randomAccess.getFilePointer();
        CRC32 cRC32 = new CRC32();
        InputStream inputStream = this.m_file.openForRead();
        ChecksumInputStream checksumInputStream = new ChecksumInputStream(inputStream, (Checksum)cRC32);
        try {
            countingOutputStream = new CountingOutputStream((OutputStream)new RandomAccessToOutputStreamAdapter(randomAccess, false));
            OutputStream outputStream = this.m_effectiveSettings.getCompressionMethod().createOutputStream((OutputStream)countingOutputStream);
            try {
                l2 = StreamUtil.copyStreams((InputStream)checksumInputStream, (OutputStream)outputStream, (int)16384);
            }
            catch (WrappedIOException wrappedIOException) {
                throw wrappedIOException.getWrapped();
            }
            finally {
                outputStream.close();
            }
            l = countingOutputStream.getNoOfBytesWritten();
        }
        finally {
            checksumInputStream.close();
        }
        if (this.m_effectiveSettings.getCompressionMethod() instanceof StoredCompressionMethod || l < l2) {
            return new FileWriteResult(this.m_effectiveSettings.getCompressionMethod(), cRC32.getValue(), l2, l);
        }
        randomAccess.setLength(l3);
        inputStream = this.m_file.openForRead();
        try {
            countingOutputStream = new RandomAccessToOutputStreamAdapter(randomAccess, false);
            try {
                StreamUtil.copyStreams((InputStream)inputStream, (OutputStream)countingOutputStream, (int)16384);
            }
            catch (WrappedIOException wrappedIOException) {
                throw wrappedIOException.getWrapped();
            }
            finally {
                countingOutputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return new FileWriteResult(StoredCompressionMethod.INSTANCE, cRC32.getValue(), l2, l2);
    }
}

