/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.at4j.zip.builder.FileWriteResult;
import org.at4j.zip.builder.FileWriteStrategy;
import org.at4j.zip.builder.ZipEntrySettings;
import org.entityfs.RandomAccess;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.ChecksumInputStream;
import org.entityfs.support.io.CountingInputStream;
import org.entityfs.support.io.CountingOutputStream;
import org.entityfs.support.io.StreamUtil;
import org.entityfs.util.io.RandomAccessToOutputStreamAdapter;

final class StreamFileWriteStrategy
implements FileWriteStrategy {
    private final InputStream m_stream;
    private final ZipEntrySettings m_effectiveSettings;

    public StreamFileWriteStrategy(InputStream inputStream, ZipEntrySettings zipEntrySettings) {
        inputStream.getClass();
        zipEntrySettings.getClass();
        this.m_stream = inputStream;
        this.m_effectiveSettings = zipEntrySettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWriteResult writeFile(RandomAccess randomAccess) throws IOException {
        long l;
        CRC32 cRC32 = new CRC32();
        CountingInputStream countingInputStream = new CountingInputStream(this.m_stream);
        ChecksumInputStream checksumInputStream = new ChecksumInputStream((InputStream)countingInputStream, (Checksum)cRC32);
        try {
            CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)new RandomAccessToOutputStreamAdapter(randomAccess, false));
            OutputStream outputStream = this.m_effectiveSettings.getCompressionMethod().createOutputStream((OutputStream)countingOutputStream);
            try {
                StreamUtil.copyStreams((InputStream)checksumInputStream, (OutputStream)outputStream, (int)16384);
            }
            catch (WrappedIOException wrappedIOException) {
                throw wrappedIOException.getWrapped();
            }
            finally {
                outputStream.close();
            }
            l = countingOutputStream.getNoOfBytesWritten();
        }
        finally {
            checksumInputStream.close();
        }
        long l2 = countingInputStream.getNoOfBytesReadOrSkipped();
        return new FileWriteResult(this.m_effectiveSettings.getCompressionMethod(), cRC32.getValue(), l2, l);
    }
}

