/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.at4j.archive.builder.AbstractStreamAddCapableArchiveBuilder;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.support.util.MsDosDate;
import org.at4j.support.util.MsDosTime;
import org.at4j.zip.ZipGeneralPurposeBitFlags;
import org.at4j.zip.ZipInternalFileAttributes;
import org.at4j.zip.builder.DefaultInternalFileAttributesStrategy;
import org.at4j.zip.builder.FileWriteResult;
import org.at4j.zip.builder.FileWriteStrategy;
import org.at4j.zip.builder.InternalFileAttributesStrategy;
import org.at4j.zip.builder.RereadableFileWriteStrategy;
import org.at4j.zip.builder.StreamFileWriteStrategy;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.builder.ZipBuilderConstants;
import org.at4j.zip.builder.ZipBuilderSettings;
import org.at4j.zip.builder.ZipEntrySettings;
import org.at4j.zip.comp.StoredCompressionMethod;
import org.at4j.zip.ef.ZipEntryExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldFactory;
import org.at4j.zip.extattrs.UnixEntityType;
import org.at4j.zip.extattrs.ZipExternalFileAttributes;
import org.entityfs.RandomAccess;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.lock.DummyLock;
import org.entityfs.lock.ReadLockRequiredException;
import org.entityfs.lock.ReadLockable;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.RandomAccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipBuilder
extends AbstractStreamAddCapableArchiveBuilder<ZipBuilder, ZipEntrySettings>
implements ZipBuilderConfiguration {
    private static final int LOCAL_HEADER_SIZE = 30;
    private static final int CENTRAL_HEADER_SIZE = 46;
    private static final int END_OF_CENTRAL_DIRECTORY_RECORD_SIZE = 22;
    private static final byte[] LOCAL_FILE_HEADER_SIGNATURE = new byte[]{4, 3, 75, 80};
    private static final byte[] CENTRAL_FILE_HEADER_SIGNATURE = new byte[]{2, 1, 75, 80};
    private static final byte[] END_OF_CENTRAL_DIRECTORY_SIGNATURE = new byte[]{6, 5, 75, 80};
    private static final byte[] ZERO_BYTES = new byte[]{0, 0, 0, 0};
    private final Lock m_targetWriteLock;
    private final RandomAccess m_targetRandomAccess;
    private final boolean m_closeRandomAccessWhenClosingBuilder;
    private final Charset m_fileNameEncodingCharset;
    private final Charset m_textEncodingCharset;
    private final ByteArrayOutputStream m_centralHeaderStream;
    private InternalFileAttributesStrategy m_internalFileAttributesStrategy;
    private final String m_fileComment;
    private int m_numberOfEntriesInCentralDirectory;
    private boolean m_closed;

    public ZipBuilder(RandomlyAccessibleFile randomlyAccessibleFile) throws WrappedIOException {
        this(randomlyAccessibleFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipBuilder(RandomlyAccessibleFile randomlyAccessibleFile, ZipBuilderSettings zipBuilderSettings) throws WrappedIOException {
        super(zipBuilderSettings != null ? ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS.combineWith(zipBuilderSettings.getDefaultFileEntrySettings()) : ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS, zipBuilderSettings != null ? ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS.combineWith(zipBuilderSettings.getDefaultDirectoryEntrySettings()) : ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS);
        randomlyAccessibleFile.getClass();
        this.m_fileNameEncodingCharset = zipBuilderSettings != null ? zipBuilderSettings.getFileNameEncodingCharset() : ZipBuilderSettings.DEFAULT_FILE_NAME_ENCODING_CHARSET;
        this.m_textEncodingCharset = zipBuilderSettings != null ? zipBuilderSettings.getTextEncodingCharset() : ZipBuilderSettings.DEFAULT_TEXT_ENCODING_CHARSET;
        this.m_centralHeaderStream = new ByteArrayOutputStream();
        this.m_closeRandomAccessWhenClosingBuilder = true;
        this.m_internalFileAttributesStrategy = zipBuilderSettings != null ? zipBuilderSettings.getInternalFileAttributesStrategy() : new DefaultInternalFileAttributesStrategy();
        this.m_fileComment = zipBuilderSettings != null ? zipBuilderSettings.getFileComment() : "*** Created by AT4J -- www.at4j.org ***";
        boolean bl = false;
        RandomAccess randomAccess = null;
        this.m_targetWriteLock = randomlyAccessibleFile.lockForWriting();
        try {
            randomAccess = randomlyAccessibleFile.openForRandomAccess(RandomAccessMode.READ_WRITE);
            randomAccess.setLength(0L);
            this.m_targetRandomAccess = randomAccess;
            bl = true;
        }
        finally {
            if (!bl) {
                this.m_closed = true;
                this.m_targetWriteLock.unlock();
                if (randomAccess != null) {
                    randomAccess.close();
                }
            }
        }
    }

    public ZipBuilder(RandomAccess randomAccess, ZipBuilderSettings zipBuilderSettings) throws WrappedIOException {
        super(zipBuilderSettings != null ? ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS.combineWith(zipBuilderSettings.getDefaultFileEntrySettings()) : ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS, zipBuilderSettings != null ? ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS.combineWith(zipBuilderSettings.getDefaultDirectoryEntrySettings()) : ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS);
        randomAccess.getClass();
        this.m_fileNameEncodingCharset = zipBuilderSettings != null ? zipBuilderSettings.getFileNameEncodingCharset() : ZipBuilderSettings.DEFAULT_FILE_NAME_ENCODING_CHARSET;
        this.m_textEncodingCharset = zipBuilderSettings != null ? zipBuilderSettings.getTextEncodingCharset() : ZipBuilderSettings.DEFAULT_TEXT_ENCODING_CHARSET;
        this.m_centralHeaderStream = new ByteArrayOutputStream();
        this.m_closeRandomAccessWhenClosingBuilder = false;
        this.m_targetRandomAccess = randomAccess;
        this.m_targetWriteLock = DummyLock.INSTANCE;
        this.m_internalFileAttributesStrategy = zipBuilderSettings != null ? zipBuilderSettings.getInternalFileAttributesStrategy() : new DefaultInternalFileAttributesStrategy();
        this.m_fileComment = zipBuilderSettings != null ? zipBuilderSettings.getFileComment() : "*** Created by AT4J -- www.at4j.org ***";
    }

    public ZipBuilder setInternalFileAttributesStrategy(InternalFileAttributesStrategy internalFileAttributesStrategy) {
        internalFileAttributesStrategy.getClass();
        this.m_internalFileAttributesStrategy = internalFileAttributesStrategy;
        return this;
    }

    public InternalFileAttributesStrategy getInternalFileAttributesStrategy() {
        return this.m_internalFileAttributesStrategy;
    }

    @Override
    protected ZipEntrySettings getDefaultDefaultDirectoryEntrySettings() {
        return ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS;
    }

    @Override
    protected ZipEntrySettings getDefaultDefaultFileEntrySettings() {
        return ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS;
    }

    public String getFileComment() {
        return this.m_fileComment;
    }

    @Override
    public Charset getFileNameEncodingCharset() {
        return this.m_fileNameEncodingCharset;
    }

    @Override
    public Charset getTextEncodingCharset() {
        return this.m_textEncodingCharset;
    }

    @Override
    protected void assertNotClosed() throws IllegalStateException {
        if (this.m_closed) {
            throw new IllegalStateException("This ZipBuilder is closed");
        }
    }

    protected void assertReadLocked(ReadLockable readLockable) throws ReadLockRequiredException {
        if (!readLockable.isReadLockedByCurrentThread()) {
            throw new ReadLockRequiredException(readLockable + " must be locked for reading when calling this method.");
        }
    }

    private byte[] createGeneralPurposeBitFlags(ZipEntrySettings zipEntrySettings) {
        ZipGeneralPurposeBitFlags zipGeneralPurposeBitFlags = new ZipGeneralPurposeBitFlags();
        return zipGeneralPurposeBitFlags.toBytes(zipEntrySettings.getCompressionMethod());
    }

    private ExtraFieldsCreationResult createExtraFields(AbsoluteLocation absoluteLocation, UnixEntityType unixEntityType, Object object, ZipEntrySettings zipEntrySettings) {
        ExtraFieldsCreationResult extraFieldsCreationResult = new ExtraFieldsCreationResult();
        int n = 0;
        int n2 = 0;
        extraFieldsCreationResult.m_centralHeaderExtraFieldFragments = new ArrayList();
        extraFieldsCreationResult.m_localHeaderExtraFieldFragments = new ArrayList();
        for (ZipEntryExtraFieldFactory zipEntryExtraFieldFactory : zipEntrySettings.getExtraFieldFactories()) {
            byte[] byArray = zipEntryExtraFieldFactory.getCode().getBigEndianByteArray();
            ZipEntryExtraField zipEntryExtraField = zipEntryExtraFieldFactory.create(true, absoluteLocation, unixEntityType, object, zipEntrySettings);
            byte[] byArray2 = zipEntryExtraField.encode(this);
            byte[] byArray3 = UnsignedShort.valueOf(byArray2.length).getBigEndianByteArray();
            byte[] byArray4 = new byte[]{byArray[0], byArray[1], byArray3[0], byArray3[1]};
            extraFieldsCreationResult.m_localHeaderExtraFieldFragments.add(byArray4);
            if (byArray2.length > 0) {
                extraFieldsCreationResult.m_localHeaderExtraFieldFragments.add(byArray2);
            }
            n2 += 4 + byArray2.length;
            zipEntryExtraField = zipEntryExtraFieldFactory.create(false, absoluteLocation, unixEntityType, object, zipEntrySettings);
            byArray2 = zipEntryExtraField.encode(this);
            byArray3 = UnsignedShort.valueOf(byArray2.length).getBigEndianByteArray();
            byArray4 = new byte[]{byArray[0], byArray[1], byArray3[0], byArray3[1]};
            extraFieldsCreationResult.m_centralHeaderExtraFieldFragments.add(byArray4);
            if (byArray2.length > 0) {
                extraFieldsCreationResult.m_centralHeaderExtraFieldFragments.add(byArray2);
            }
            n += 4 + byArray2.length;
        }
        extraFieldsCreationResult.m_centralHeaderExtraFieldSize = UnsignedShort.valueOf(n);
        extraFieldsCreationResult.m_localHeaderExtraFieldSize = UnsignedShort.valueOf(n2);
        return extraFieldsCreationResult;
    }

    private byte[][] createFileHeaders(ZipEntrySettings zipEntrySettings, Date date, FileWriteResult fileWriteResult, UnsignedShort unsignedShort, UnsignedShort unsignedShort2, UnsignedShort unsignedShort3, UnsignedShort unsignedShort4, ZipInternalFileAttributes zipInternalFileAttributes, UnsignedInteger unsignedInteger, ZipExternalFileAttributes zipExternalFileAttributes) {
        byte[] byArray;
        byte[] byArray2 = new byte[30];
        byte[] byArray3 = new byte[46];
        byArray2[0] = LOCAL_FILE_HEADER_SIGNATURE[3];
        byArray2[1] = LOCAL_FILE_HEADER_SIGNATURE[2];
        byArray2[2] = LOCAL_FILE_HEADER_SIGNATURE[1];
        byArray2[3] = LOCAL_FILE_HEADER_SIGNATURE[0];
        byArray3[0] = CENTRAL_FILE_HEADER_SIGNATURE[3];
        byArray3[1] = CENTRAL_FILE_HEADER_SIGNATURE[2];
        byArray3[2] = CENTRAL_FILE_HEADER_SIGNATURE[1];
        byArray3[3] = CENTRAL_FILE_HEADER_SIGNATURE[0];
        if (fileWriteResult != null) {
            byArray = fileWriteResult.getCompressionMethod().getVersionNeededToExtract().getBigEndianByteArray();
        } else {
            byte[] byArray4 = new byte[2];
            byArray4[0] = 10;
            byArray = byArray4;
            byArray4[1] = 0;
        }
        byte[] byArray5 = byArray;
        byArray3[4] = byArray5[0];
        byArray3[5] = zipExternalFileAttributes.getVersionMadeBy().getCode().byteValue();
        byArray2[4] = byArray5[0];
        byArray2[5] = byArray5[1];
        byArray3[6] = byArray5[0];
        byArray3[7] = byArray5[1];
        byte[] byArray6 = this.createGeneralPurposeBitFlags(zipEntrySettings);
        byArray2[6] = byArray6[0];
        byArray2[7] = byArray6[1];
        byArray3[8] = byArray6[0];
        byArray3[9] = byArray6[1];
        byte[] byArray7 = fileWriteResult != null ? fileWriteResult.getCompressionMethod().getCode().getBigEndianByteArray() : StoredCompressionMethod.CODE.getBigEndianByteArray();
        byArray2[8] = byArray7[0];
        byArray2[9] = byArray7[1];
        byArray3[10] = byArray7[0];
        byArray3[11] = byArray7[1];
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        byte[] byArray8 = MsDosTime.encodeMsDosTime(calendar).getBigEndianByteArray();
        byArray2[10] = byArray8[0];
        byArray2[11] = byArray8[1];
        byArray3[12] = byArray8[0];
        byArray3[13] = byArray8[1];
        byte[] byArray9 = MsDosDate.encodeMsDosDate(calendar).getBigEndianByteArray();
        byArray2[12] = byArray9[0];
        byArray2[13] = byArray9[1];
        byArray3[14] = byArray9[0];
        byArray3[15] = byArray9[1];
        byte[] byArray10 = fileWriteResult != null ? UnsignedInteger.valueOf(fileWriteResult.getCrc32Checksum()).getBigEndianByteArray() : ZERO_BYTES;
        byArray2[14] = byArray10[0];
        byArray2[15] = byArray10[1];
        byArray2[16] = byArray10[2];
        byArray2[17] = byArray10[3];
        byArray3[16] = byArray10[0];
        byArray3[17] = byArray10[1];
        byArray3[18] = byArray10[2];
        byArray3[19] = byArray10[3];
        byte[] byArray11 = fileWriteResult != null ? UnsignedInteger.valueOf(fileWriteResult.getCompressedSize()).getBigEndianByteArray() : ZERO_BYTES;
        byArray2[18] = byArray11[0];
        byArray2[19] = byArray11[1];
        byArray2[20] = byArray11[2];
        byArray2[21] = byArray11[3];
        byArray3[20] = byArray11[0];
        byArray3[21] = byArray11[1];
        byArray3[22] = byArray11[2];
        byArray3[23] = byArray11[3];
        byte[] byArray12 = fileWriteResult != null ? UnsignedInteger.valueOf(fileWriteResult.getUncompressedSize()).getBigEndianByteArray() : ZERO_BYTES;
        byArray2[22] = byArray12[0];
        byArray2[23] = byArray12[1];
        byArray2[24] = byArray12[2];
        byArray2[25] = byArray12[3];
        byArray3[24] = byArray12[0];
        byArray3[25] = byArray12[1];
        byArray3[26] = byArray12[2];
        byArray3[27] = byArray12[3];
        byte[] byArray13 = unsignedShort.getBigEndianByteArray();
        byArray2[26] = byArray13[0];
        byArray2[27] = byArray13[1];
        byArray3[28] = byArray13[0];
        byArray3[29] = byArray13[1];
        byte[] byArray14 = unsignedShort3.getBigEndianByteArray();
        byArray2[28] = byArray14[0];
        byArray2[29] = byArray14[1];
        byte[] byArray15 = unsignedShort4.getBigEndianByteArray();
        byArray3[30] = byArray15[0];
        byArray3[31] = byArray15[1];
        byte[] byArray16 = unsignedShort2.getBigEndianByteArray();
        byArray3[32] = byArray16[0];
        byArray3[33] = byArray16[1];
        byArray3[34] = 0;
        byArray3[35] = 0;
        byte[] byArray17 = zipInternalFileAttributes.getEncodedValue().getBigEndianByteArray();
        byArray3[36] = byArray17[0];
        byArray3[37] = byArray17[1];
        byte[] byArray18 = zipExternalFileAttributes.getEncodedValue().getBigEndianByteArray();
        byArray3[38] = byArray18[0];
        byArray3[39] = byArray18[1];
        byArray3[40] = byArray18[2];
        byArray3[41] = byArray18[3];
        byte[] byArray19 = unsignedInteger.getBigEndianByteArray();
        byArray3[42] = byArray19[0];
        byArray3[43] = byArray19[1];
        byArray3[44] = byArray19[2];
        byArray3[45] = byArray19[3];
        return new byte[][]{byArray2, byArray3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(AbsoluteLocation absoluteLocation, FileWriteStrategy fileWriteStrategy, Object object, ZipEntrySettings zipEntrySettings, Date date) throws IOException {
        byte[][] byArray;
        byte[] byArray2;
        Iterator iterator;
        Object object22;
        byte[] byArray3 = absoluteLocation.getLocation().substring(1).getBytes(this.m_fileNameEncodingCharset.name());
        ExtraFieldsCreationResult extraFieldsCreationResult = this.createExtraFields(absoluteLocation, UnixEntityType.REGULAR_FILE, object, zipEntrySettings);
        long l = this.m_targetRandomAccess.getFilePointer();
        boolean bl = false;
        try {
            this.m_targetRandomAccess.seek(l + 30L);
            this.m_targetRandomAccess.write(byArray3);
            for (Object object22 : extraFieldsCreationResult.m_localHeaderExtraFieldFragments) {
                this.m_targetRandomAccess.write(object22);
            }
            iterator = fileWriteStrategy.writeFile(this.m_targetRandomAccess);
            object22 = zipEntrySettings.getComment();
            byArray2 = object22 != null ? object22.getBytes(this.m_textEncodingCharset.name()) : new byte[]{};
            ZipInternalFileAttributes zipInternalFileAttributes = this.m_internalFileAttributesStrategy.createInternalFileAttributes(UnixEntityType.REGULAR_FILE, absoluteLocation);
            ZipExternalFileAttributes zipExternalFileAttributes = zipEntrySettings.getExternalFileAttributesFactory().create(UnixEntityType.REGULAR_FILE, absoluteLocation, object);
            byArray = this.createFileHeaders(zipEntrySettings, date, (FileWriteResult)((Object)iterator), UnsignedShort.valueOf(byArray3.length), UnsignedShort.valueOf(byArray2.length), extraFieldsCreationResult.m_localHeaderExtraFieldSize, extraFieldsCreationResult.m_centralHeaderExtraFieldSize, zipInternalFileAttributes, UnsignedInteger.valueOf(l), zipExternalFileAttributes);
            long l2 = this.m_targetRandomAccess.getFilePointer();
            this.m_targetRandomAccess.seek(l);
            this.m_targetRandomAccess.write(byArray[0]);
            assert (this.m_targetRandomAccess.getFilePointer() == l + 30L);
            this.m_targetRandomAccess.seek(l2);
            bl = true;
        }
        finally {
            if (!bl) {
                this.m_targetRandomAccess.setLength(l);
                this.m_targetRandomAccess.seek(l);
            }
        }
        this.m_centralHeaderStream.write(byArray[1]);
        this.m_centralHeaderStream.write(byArray3);
        iterator = extraFieldsCreationResult.m_centralHeaderExtraFieldFragments.iterator();
        while (iterator.hasNext()) {
            object22 = (byte[])iterator.next();
            this.m_centralHeaderStream.write((byte[])object22);
        }
        this.m_centralHeaderStream.write(byArray2);
        ++this.m_numberOfEntriesInCentralDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectory(AbsoluteLocation absoluteLocation, Object object, ZipEntrySettings zipEntrySettings, Date date) throws IOException {
        byte[][] byArray;
        byte[] byArray2;
        Object object2;
        Object object3;
        byte[] byArray3 = (absoluteLocation.getLocation() + "/").substring(1).getBytes(this.m_fileNameEncodingCharset.name());
        ExtraFieldsCreationResult extraFieldsCreationResult = this.createExtraFields(absoluteLocation, UnixEntityType.DIRECTORY, object, zipEntrySettings);
        long l = this.m_targetRandomAccess.getFilePointer();
        boolean bl = false;
        try {
            object3 = this.m_internalFileAttributesStrategy.createInternalFileAttributes(UnixEntityType.DIRECTORY, absoluteLocation);
            object2 = zipEntrySettings.getExternalFileAttributesFactory().create(UnixEntityType.DIRECTORY, absoluteLocation, object);
            String string = zipEntrySettings.getComment();
            byArray2 = string != null ? string.getBytes(this.m_textEncodingCharset.name()) : new byte[]{};
            byArray = this.createFileHeaders(zipEntrySettings, date, null, UnsignedShort.valueOf(byArray3.length), UnsignedShort.valueOf(byArray2.length), extraFieldsCreationResult.m_localHeaderExtraFieldSize, extraFieldsCreationResult.m_centralHeaderExtraFieldSize, (ZipInternalFileAttributes)object3, UnsignedInteger.valueOf(l), (ZipExternalFileAttributes)object2);
            this.m_targetRandomAccess.write(byArray[0]);
            this.m_targetRandomAccess.write(byArray3);
            for (byte[] byArray4 : extraFieldsCreationResult.m_localHeaderExtraFieldFragments) {
                this.m_targetRandomAccess.write(byArray4);
            }
            bl = true;
        }
        finally {
            if (!bl) {
                this.m_targetRandomAccess.setLength(l);
                this.m_targetRandomAccess.seek(l);
            }
        }
        this.m_centralHeaderStream.write(byArray[1]);
        this.m_centralHeaderStream.write(byArray3);
        object3 = extraFieldsCreationResult.m_centralHeaderExtraFieldFragments.iterator();
        while (object3.hasNext()) {
            object2 = (byte[])object3.next();
            this.m_centralHeaderStream.write((byte[])object2);
        }
        this.m_centralHeaderStream.write(byArray2);
        ++this.m_numberOfEntriesInCentralDirectory;
    }

    @Override
    protected void addDirectoryCallback(AbsoluteLocation absoluteLocation, Object object, ZipEntrySettings zipEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        try {
            this.writeDirectory(absoluteLocation, object, zipEntrySettings, date);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    @Override
    protected void addFileCallback(AbsoluteLocation absoluteLocation, ReadableFile readableFile, ZipEntrySettings zipEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        try {
            this.writeFile(absoluteLocation, new RereadableFileWriteStrategy(readableFile, zipEntrySettings), readableFile, zipEntrySettings, date);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    @Override
    protected void addStreamCallback(AbsoluteLocation absoluteLocation, InputStream inputStream, ZipEntrySettings zipEntrySettings, Date date) throws WrappedIOException, ArchiveEntryAddException {
        try {
            this.writeFile(absoluteLocation, new StreamFileWriteStrategy(inputStream, zipEntrySettings), inputStream, zipEntrySettings, date);
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    @Override
    public boolean isClosed() {
        return this.m_closed;
    }

    private byte[] createEndOfCentralDirectoryRecord(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) {
        byte[] byArray = this.m_fileComment != null ? Charsets.getBytes(this.m_fileComment, this.m_textEncodingCharset) : new byte[]{};
        byte[] byArray2 = new byte[22 + byArray.length];
        byArray2[0] = END_OF_CENTRAL_DIRECTORY_SIGNATURE[3];
        byArray2[1] = END_OF_CENTRAL_DIRECTORY_SIGNATURE[2];
        byArray2[2] = END_OF_CENTRAL_DIRECTORY_SIGNATURE[1];
        byArray2[3] = END_OF_CENTRAL_DIRECTORY_SIGNATURE[0];
        byArray2[4] = 0;
        byArray2[5] = 0;
        byArray2[6] = 0;
        byArray2[7] = 0;
        byte[] byArray3 = UnsignedShort.valueOf(this.m_numberOfEntriesInCentralDirectory).getBigEndianByteArray();
        byArray2[8] = byArray3[0];
        byArray2[9] = byArray3[1];
        byArray2[10] = byArray3[0];
        byArray2[11] = byArray3[1];
        byte[] byArray4 = unsignedInteger2.getBigEndianByteArray();
        byArray2[12] = byArray4[0];
        byArray2[13] = byArray4[1];
        byArray2[14] = byArray4[2];
        byArray2[15] = byArray4[3];
        byte[] byArray5 = unsignedInteger.getBigEndianByteArray();
        byArray2[16] = byArray5[0];
        byArray2[17] = byArray5[1];
        byArray2[18] = byArray5[2];
        byArray2[19] = byArray5[3];
        byte[] byArray6 = UnsignedShort.valueOf(byArray.length).getBigEndianByteArray();
        byArray2[20] = byArray6[0];
        byArray2[21] = byArray6[1];
        if (byArray.length > 0) {
            System.arraycopy(byArray, 0, byArray2, 22, byArray.length);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws WrappedIOException {
        if (!this.m_closed) {
            try {
                try {
                    try {
                        this.m_centralHeaderStream.close();
                    }
                    catch (IOException iOException) {
                        throw new WrappedIOException(iOException);
                    }
                    long l = this.m_targetRandomAccess.getFilePointer();
                    this.m_targetRandomAccess.write(this.m_centralHeaderStream.toByteArray());
                    long l2 = this.m_targetRandomAccess.getFilePointer() - l;
                    this.m_targetRandomAccess.write(this.createEndOfCentralDirectoryRecord(UnsignedInteger.valueOf(l), UnsignedInteger.valueOf(l2)));
                }
                finally {
                    if (this.m_closeRandomAccessWhenClosingBuilder) {
                        this.m_targetRandomAccess.close();
                    }
                }
            }
            finally {
                this.m_targetWriteLock.unlock();
                this.m_closed = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static class ExtraFieldsCreationResult {
        private List<byte[]> m_localHeaderExtraFieldFragments;
        private List<byte[]> m_centralHeaderExtraFieldFragments;
        private UnsignedShort m_localHeaderExtraFieldSize;
        private UnsignedShort m_centralHeaderExtraFieldSize;

        private ExtraFieldsCreationResult() {
        }
    }
}

