/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.builder;

import java.nio.charset.Charset;
import org.at4j.comp.CompressionLevel;
import org.at4j.zip.builder.DefaultInternalFileAttributesStrategy;
import org.at4j.zip.builder.InternalFileAttributesStrategy;
import org.at4j.zip.builder.ZipBuilderConstants;
import org.at4j.zip.builder.ZipEntrySettings;

public class ZipBuilderSettings {
    static final Charset DEFAULT_FILE_NAME_ENCODING_CHARSET = Charset.defaultCharset();
    static final Charset DEFAULT_TEXT_ENCODING_CHARSET = Charset.defaultCharset();
    public static final String DEFAULT_FILE_COMMENT = "*** Created by AT4J -- www.at4j.org ***";
    private ZipEntrySettings m_defaultFileEntrySettings = new ZipEntrySettings(ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_FILE_ENTRY_SETTINGS);
    private ZipEntrySettings m_defaultDirectoryEntrySettings = new ZipEntrySettings(ZipBuilderConstants.DEFAULT_DEFAULT_ZIP_DIRECTORY_ENTRY_SETTINGS);
    private Charset m_fileNameEncodingCharset = DEFAULT_FILE_NAME_ENCODING_CHARSET;
    private Charset m_textEncodingCharset = DEFAULT_TEXT_ENCODING_CHARSET;
    private InternalFileAttributesStrategy m_internalFileAttributesStrategy = new DefaultInternalFileAttributesStrategy();
    private String m_fileComment = "*** Created by AT4J -- www.at4j.org ***";

    public ZipEntrySettings getDefaultFileEntrySettings() {
        return this.m_defaultFileEntrySettings;
    }

    public ZipBuilderSettings setDefaultFileEntrySettings(ZipEntrySettings zipEntrySettings) {
        zipEntrySettings.getClass();
        this.m_defaultFileEntrySettings = zipEntrySettings;
        return this;
    }

    public ZipBuilderSettings setCompressionLevel(CompressionLevel compressionLevel) {
        this.m_defaultFileEntrySettings.setCompressionMethod(this.m_defaultFileEntrySettings.getCompressionMethod().createWithCompressionLevel(compressionLevel));
        return this;
    }

    public ZipEntrySettings getDefaultDirectoryEntrySettings() {
        return this.m_defaultDirectoryEntrySettings;
    }

    public ZipBuilderSettings setDefaultDirectoryEntrySettings(ZipEntrySettings zipEntrySettings) {
        zipEntrySettings.getClass();
        this.m_defaultDirectoryEntrySettings = zipEntrySettings;
        return this;
    }

    public Charset getFileNameEncodingCharset() {
        return this.m_fileNameEncodingCharset;
    }

    public ZipBuilderSettings setFileNameEncodingCharset(Charset charset) {
        charset.getClass();
        this.m_fileNameEncodingCharset = charset;
        return this;
    }

    public Charset getTextEncodingCharset() {
        return this.m_textEncodingCharset;
    }

    public ZipBuilderSettings setTextEncodingCharset(Charset charset) {
        charset.getClass();
        this.m_textEncodingCharset = charset;
        return this;
    }

    public InternalFileAttributesStrategy getInternalFileAttributesStrategy() {
        return this.m_internalFileAttributesStrategy;
    }

    public ZipBuilderSettings setInternalFileAttributesStrategy(InternalFileAttributesStrategy internalFileAttributesStrategy) {
        internalFileAttributesStrategy.getClass();
        this.m_internalFileAttributesStrategy = internalFileAttributesStrategy;
        return this;
    }

    public String getFileComment() {
        return this.m_fileComment;
    }

    public ZipBuilderSettings setFileComment(String string) {
        this.m_fileComment = string;
        return this;
    }
}

