/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.at4j.archive.builder.ArchiveEntrySettings;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.at4j.zip.ef.ZipEntryExtraFieldFactory;
import org.at4j.zip.extattrs.ZipExternalFileAttributesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntrySettings
implements ArchiveEntrySettings<ZipEntrySettings> {
    private ZipEntryCompressionMethod m_compressionMethod;
    private ZipExternalFileAttributesFactory m_externalFileAttributesFactory;
    private String m_comment;
    private List<ZipEntryExtraFieldFactory> m_extraFieldFactories;
    private boolean m_readOnly;

    public ZipEntrySettings() {
        this.m_extraFieldFactories = new ArrayList<ZipEntryExtraFieldFactory>(4);
    }

    public ZipEntrySettings(ZipEntrySettings zipEntrySettings) {
        this.m_compressionMethod = zipEntrySettings.m_compressionMethod;
        this.m_externalFileAttributesFactory = zipEntrySettings.m_externalFileAttributesFactory;
        this.m_comment = zipEntrySettings.m_comment;
        this.m_extraFieldFactories = new ArrayList<ZipEntryExtraFieldFactory>(zipEntrySettings.m_extraFieldFactories);
        this.m_readOnly = false;
    }

    private void assertNotReadOnly() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("This configuration object is read only");
        }
    }

    @Override
    public ZipEntrySettings setReadOnly() {
        this.m_readOnly = true;
        return this;
    }

    public ZipEntrySettings setCompressionMethod(ZipEntryCompressionMethod zipEntryCompressionMethod) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_compressionMethod = zipEntryCompressionMethod;
        return this;
    }

    public ZipEntryCompressionMethod getCompressionMethod() {
        return this.m_compressionMethod;
    }

    public ZipEntrySettings setExternalFileAttributesFactory(ZipExternalFileAttributesFactory zipExternalFileAttributesFactory) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_externalFileAttributesFactory = zipExternalFileAttributesFactory;
        return this;
    }

    public ZipExternalFileAttributesFactory getExternalFileAttributesFactory() {
        return this.m_externalFileAttributesFactory;
    }

    public ZipEntrySettings setComment(String string) throws IllegalStateException {
        this.assertNotReadOnly();
        this.m_comment = string;
        return this;
    }

    public String getComment() {
        return this.m_comment;
    }

    public ZipEntrySettings addExtraFieldFactory(ZipEntryExtraFieldFactory zipEntryExtraFieldFactory) throws IllegalStateException {
        this.assertNotReadOnly();
        zipEntryExtraFieldFactory.getClass();
        this.m_extraFieldFactories.add(zipEntryExtraFieldFactory);
        return this;
    }

    public List<ZipEntryExtraFieldFactory> getExtraFieldFactories() {
        return Collections.unmodifiableList(this.m_extraFieldFactories);
    }

    @Override
    public ZipEntrySettings combineWith(ZipEntrySettings zipEntrySettings) {
        ZipEntrySettings zipEntrySettings2 = this.clone();
        if (zipEntrySettings.getCompressionMethod() != null) {
            zipEntrySettings2.setCompressionMethod(zipEntrySettings.getCompressionMethod());
        }
        if (zipEntrySettings.getExternalFileAttributesFactory() != null) {
            zipEntrySettings2.setExternalFileAttributesFactory(zipEntrySettings.getExternalFileAttributesFactory());
        }
        if (zipEntrySettings.getComment() != null) {
            zipEntrySettings2.setComment(zipEntrySettings.getComment());
        }
        zipEntrySettings2.m_extraFieldFactories.addAll(this.m_extraFieldFactories);
        zipEntrySettings2.m_extraFieldFactories.addAll(zipEntrySettings.m_extraFieldFactories);
        return zipEntrySettings2;
    }

    @Override
    public ZipEntrySettings clone() {
        try {
            ZipEntrySettings zipEntrySettings = (ZipEntrySettings)super.clone();
            zipEntrySettings.m_readOnly = false;
            zipEntrySettings.m_extraFieldFactories = new ArrayList<ZipEntryExtraFieldFactory>(4);
            zipEntrySettings.m_extraFieldFactories.addAll(this.m_extraFieldFactories);
            return zipEntrySettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Bug: ", cloneNotSupportedException);
        }
    }
}

