/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.comp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.comp.CompressionLevel;
import org.at4j.comp.bzip2.BZip2InputStream;
import org.at4j.comp.bzip2.BZip2OutputStream;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.ZipGeneralPurposeBitFlags;
import org.at4j.zip.comp.UnsupportedCompressionMethodException;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.at4j.zip.comp.ZipEntryCompressionMethodFactory;
import org.entityfs.RandomAccess;

public class BZip2CompressionMethod
implements ZipEntryCompressionMethod,
ZipEntryCompressionMethodFactory {
    private static final int BLOCK_SIZE_NOT_CONFIGURED = -1;
    public static final UnsignedShort CODE = UnsignedShort.valueOf(12);
    public static final String NAME = "bzip2";
    public static final UnsignedShort VERSION_NEEDED_TO_EXTRACT = UnsignedShort.valueOf(46);
    public static final BZip2CompressionMethod INSTANCE = new BZip2CompressionMethod();
    private final int m_blockSize;

    public BZip2CompressionMethod() {
        this.m_blockSize = -1;
    }

    public BZip2CompressionMethod(int n) throws IllegalArgumentException {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("Invalid block size. It must be a number between 1 and 9 (inclusive)");
        }
        this.m_blockSize = n;
    }

    public BZip2CompressionMethod(CompressionLevel compressionLevel) {
        switch (compressionLevel) {
            case BEST: {
                this.m_blockSize = 9;
                break;
            }
            case DEFAULT: {
                this.m_blockSize = -1;
                break;
            }
            case FASTEST: {
                this.m_blockSize = 1;
                break;
            }
            default: {
                throw new RuntimeException("Unknown compression level " + (Object)((Object)compressionLevel) + ". This is a bug");
            }
        }
    }

    public UnsignedShort getCode() {
        return CODE;
    }

    public String getName() {
        return NAME;
    }

    public UnsignedShort getVersionNeededToExtract() {
        return VERSION_NEEDED_TO_EXTRACT;
    }

    public InputStream createInputStream(InputStream inputStream, long l, long l2) throws IOException {
        return new BZip2InputStream(inputStream);
    }

    public OutputStream createOutputStream(OutputStream outputStream) throws IOException, UnsupportedCompressionMethodException {
        BZip2OutputStreamSettings bZip2OutputStreamSettings = new BZip2OutputStreamSettings();
        if (this.m_blockSize != -1) {
            bZip2OutputStreamSettings.setBlockSize(this.m_blockSize);
        }
        return new BZip2OutputStream(outputStream, bZip2OutputStreamSettings);
    }

    public BZip2CompressionMethod create(ZipGeneralPurposeBitFlags zipGeneralPurposeBitFlags) {
        return this;
    }

    public RandomAccess createRandomAccess(RandomAccess randomAccess, long l, long l2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Random access is not supported for the bzip2 compression method");
    }

    public boolean isRandomAccessSupported() {
        return false;
    }

    public ZipEntryCompressionMethod createWithCompressionLevel(CompressionLevel compressionLevel) {
        return new BZip2CompressionMethod(compressionLevel);
    }

    public String toString() {
        return "BZip2";
    }
}

