/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.comp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.at4j.comp.CompressionLevel;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.comp.UnsupportedCompressionMethodException;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.entityfs.RandomAccess;

public class DeflatedCompressionMethod
implements ZipEntryCompressionMethod {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(8);
    public static final String NAME = "Deflated";
    public static final UnsignedShort VERSION_NEEDED_TO_EXTRACT = UnsignedShort.valueOf(20);
    public static final int NORMAL_COMPRESSION_LEVEL = 6;
    public static final int FAST_COMPRESSION_LEVEL = 3;
    public static final int FASTEST_COMPRESSION_LEVEL = 1;
    public static final int MAXIMUM_COMPRESSION_LEVEL = 9;
    public static final DeflatedCompressionMethod FASTEST_COMPRESSION = new DeflatedCompressionMethod(1);
    public static final DeflatedCompressionMethod FAST_COMPRESSION = new DeflatedCompressionMethod(3);
    public static final DeflatedCompressionMethod NORMAL_COMPRESSION = new DeflatedCompressionMethod(6);
    public static final DeflatedCompressionMethod MAXIMUM_COMPRESSION = new DeflatedCompressionMethod(9);
    private final int m_compressionLevel;

    public DeflatedCompressionMethod() {
        this(6);
    }

    public DeflatedCompressionMethod(int n) throws IllegalArgumentException {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level " + n + ". It must be between 1 and 9 (inclusive)");
        }
        this.m_compressionLevel = n;
    }

    public DeflatedCompressionMethod(CompressionLevel compressionLevel) {
        switch (compressionLevel) {
            case BEST: {
                this.m_compressionLevel = 9;
                break;
            }
            case DEFAULT: {
                this.m_compressionLevel = 6;
                break;
            }
            case FASTEST: {
                this.m_compressionLevel = 1;
                break;
            }
            default: {
                throw new RuntimeException("Unknown compression level " + (Object)((Object)compressionLevel) + ". This is a bug.");
            }
        }
    }

    public UnsignedShort getCode() {
        return CODE;
    }

    public String getName() {
        return NAME;
    }

    public UnsignedShort getVersionNeededToExtract() {
        return VERSION_NEEDED_TO_EXTRACT;
    }

    public int getCompressionLevel() {
        return this.m_compressionLevel;
    }

    public InputStream createInputStream(InputStream inputStream, long l, long l2) {
        Inflater inflater = new Inflater(true);
        return new InflaterInputStream(new ExtraDummyByteAtTheEndStream(inputStream), inflater);
    }

    public OutputStream createOutputStream(OutputStream outputStream) throws IOException, UnsupportedCompressionMethodException {
        Deflater deflater = new Deflater(this.m_compressionLevel, true);
        return new DeflaterOutputStream(outputStream, deflater);
    }

    public RandomAccess createRandomAccess(RandomAccess randomAccess, long l, long l2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Random access is not supported for the Deflate compression method");
    }

    public boolean isRandomAccessSupported() {
        return false;
    }

    public String toString() {
        return "Deflated compression (" + this.m_compressionLevel + ")";
    }

    public ZipEntryCompressionMethod createWithCompressionLevel(CompressionLevel compressionLevel) {
        return new DeflatedCompressionMethod(compressionLevel);
    }

    private static class ExtraDummyByteAtTheEndStream
    extends FilterInputStream {
        private boolean m_haveReturnedDummyByte = false;

        private ExtraDummyByteAtTheEndStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = super.read();
            if (n < 0) {
                if (this.m_haveReturnedDummyByte) {
                    return n;
                }
                this.m_haveReturnedDummyByte = true;
                return 0;
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 < 0) {
                if (this.m_haveReturnedDummyByte) {
                    return n3;
                }
                this.m_haveReturnedDummyByte = true;
                byArray[0] = 0;
                return 1;
            }
            return n3;
        }
    }
}

