/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.comp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.comp.CompressionLevel;
import org.at4j.comp.lzma.LzmaInputStream;
import org.at4j.comp.lzma.LzmaInputStreamSettings;
import org.at4j.comp.lzma.LzmaOutputStream;
import org.at4j.comp.lzma.LzmaOutputStreamSettings;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipGeneralPurposeBitFlags;
import org.at4j.zip.comp.UnsupportedCompressionMethodException;
import org.at4j.zip.comp.ZipEntryCompressionMethod;
import org.at4j.zip.comp.ZipEntryCompressionMethodFactory;
import org.entityfs.RandomAccess;

public class LzmaCompressionMethod
implements ZipEntryCompressionMethod,
ZipEntryCompressionMethodFactory {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(14);
    public static final String NAME = "LZMA";
    public static final UnsignedShort VERSION_NEEDED_TO_EXTRACT = UnsignedShort.valueOf(63);
    public static final LzmaCompressionMethod DEFAULT_INSTANCE = new LzmaCompressionMethod(new LzmaOutputStreamSettings().setWriteUncompressedDataSize(false));
    private static final byte[] LZMA_HEADER = new byte[]{4, 57, 5, 0};
    private final LzmaOutputStreamSettings m_settings;

    public LzmaCompressionMethod(LzmaOutputStreamSettings lzmaOutputStreamSettings) throws IllegalArgumentException {
        if (lzmaOutputStreamSettings.isWriteUncompressedDataSize()) {
            throw new IllegalArgumentException("The writeUncompressedDataSize property must be false for the settings object");
        }
        if (!lzmaOutputStreamSettings.isWriteStreamProperties()) {
            throw new IllegalArgumentException("The writeStreamProperties property must be true for the settings object");
        }
        this.m_settings = lzmaOutputStreamSettings;
    }

    public UnsignedShort getCode() {
        return CODE;
    }

    public String getName() {
        return NAME;
    }

    public UnsignedShort getVersionNeededToExtract() {
        return VERSION_NEEDED_TO_EXTRACT;
    }

    public InputStream createInputStream(InputStream inputStream, long l, long l2) throws IOException {
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        if (n != 4) {
            throw new ZipFileParseException("Wanted to read 4 bytes. Got " + n);
        }
        int n2 = UnsignedShort.fromBigEndianByteArray(byArray, 2).intValue();
        if (n2 != 5) {
            throw new ZipFileParseException("Invalid size of LZMA property data: " + n2 + " bytes. It must be 5 bytes");
        }
        byte[] byArray2 = new byte[5];
        n = inputStream.read(byArray2);
        if (n != 5) {
            throw new ZipFileParseException("Wanted to read 5 bytes. Got " + n);
        }
        LzmaInputStreamSettings lzmaInputStreamSettings = new LzmaInputStreamSettings();
        lzmaInputStreamSettings.setProperties(byArray2);
        lzmaInputStreamSettings.setReadUncompressedSize(false);
        lzmaInputStreamSettings.setUncompressedSize(l2);
        return new LzmaInputStream(inputStream, lzmaInputStreamSettings);
    }

    public OutputStream createOutputStream(OutputStream outputStream) throws IOException, UnsupportedCompressionMethodException {
        outputStream.write(LZMA_HEADER);
        return new LzmaOutputStream(outputStream, this.m_settings);
    }

    public RandomAccess createRandomAccess(RandomAccess randomAccess, long l, long l2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Random access is not supported for the LZMA compression method");
    }

    public boolean isRandomAccessSupported() {
        return false;
    }

    public String toString() {
        return NAME;
    }

    public LzmaCompressionMethod create(ZipGeneralPurposeBitFlags zipGeneralPurposeBitFlags) {
        return this;
    }

    public ZipEntryCompressionMethod createWithCompressionLevel(CompressionLevel compressionLevel) {
        return new LzmaCompressionMethod(new LzmaOutputStreamSettings().setCompressionLevel(compressionLevel));
    }
}

