/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.comp;

import java.util.HashMap;
import java.util.Map;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.comp.BZip2CompressionMethod;
import org.at4j.zip.comp.Deflate64CompressionMethod;
import org.at4j.zip.comp.DeflatedCompressionMethod;
import org.at4j.zip.comp.DeflatedCompressionMethodFactory;
import org.at4j.zip.comp.IbmLz77CompressionMethod;
import org.at4j.zip.comp.IbmTerseCompressionMethod;
import org.at4j.zip.comp.ImplodedCompressionMethod;
import org.at4j.zip.comp.LzmaCompressionMethod;
import org.at4j.zip.comp.PKWareImplodingCompressionMethod;
import org.at4j.zip.comp.PpmdCompressionMethod;
import org.at4j.zip.comp.Reduced1CompressionMethod;
import org.at4j.zip.comp.Reduced2CompressionMethod;
import org.at4j.zip.comp.Reduced3CompressionMethod;
import org.at4j.zip.comp.Reduced4CompressionMethod;
import org.at4j.zip.comp.ShrunkCompressionMethod;
import org.at4j.zip.comp.StoredCompressionMethod;
import org.at4j.zip.comp.UnknownZipEntryCompressionMethodException;
import org.at4j.zip.comp.WavPackCompressionMethod;
import org.at4j.zip.comp.ZipEntryCompressionMethodFactory;

public class ZipEntryCompressionMethodRegistry {
    private final Map<UnsignedShort, ZipEntryCompressionMethodFactory> m_registry = new HashMap<UnsignedShort, ZipEntryCompressionMethodFactory>(16);

    public ZipEntryCompressionMethodRegistry() {
        this.m_registry.put(StoredCompressionMethod.CODE, StoredCompressionMethod.INSTANCE);
        this.m_registry.put(DeflatedCompressionMethod.CODE, DeflatedCompressionMethodFactory.INSTANCE);
        this.m_registry.put(BZip2CompressionMethod.CODE, BZip2CompressionMethod.INSTANCE);
        this.m_registry.put(LzmaCompressionMethod.CODE, LzmaCompressionMethod.DEFAULT_INSTANCE);
        this.m_registry.put(Deflate64CompressionMethod.CODE, Deflate64CompressionMethod.INSTANCE);
        this.m_registry.put(IbmLz77CompressionMethod.CODE, IbmLz77CompressionMethod.INSTANCE);
        this.m_registry.put(IbmTerseCompressionMethod.CODE, IbmTerseCompressionMethod.INSTANCE);
        this.m_registry.put(ImplodedCompressionMethod.CODE, ImplodedCompressionMethod.INSTANCE);
        this.m_registry.put(PKWareImplodingCompressionMethod.CODE, PKWareImplodingCompressionMethod.INSTANCE);
        this.m_registry.put(PpmdCompressionMethod.CODE, PpmdCompressionMethod.INSTANCE);
        this.m_registry.put(Reduced1CompressionMethod.CODE, Reduced1CompressionMethod.INSTANCE);
        this.m_registry.put(Reduced2CompressionMethod.CODE, Reduced2CompressionMethod.INSTANCE);
        this.m_registry.put(Reduced3CompressionMethod.CODE, Reduced3CompressionMethod.INSTANCE);
        this.m_registry.put(Reduced4CompressionMethod.CODE, Reduced4CompressionMethod.INSTANCE);
        this.m_registry.put(ShrunkCompressionMethod.CODE, ShrunkCompressionMethod.INSTANCE);
        this.m_registry.put(WavPackCompressionMethod.CODE, WavPackCompressionMethod.INSTANCE);
    }

    public void registerCompressionMethodFactory(ZipEntryCompressionMethodFactory zipEntryCompressionMethodFactory) {
        this.m_registry.put(zipEntryCompressionMethodFactory.getCode(), zipEntryCompressionMethodFactory);
    }

    public ZipEntryCompressionMethodFactory forCode(UnsignedShort unsignedShort) throws UnknownZipEntryCompressionMethodException {
        ZipEntryCompressionMethodFactory zipEntryCompressionMethodFactory = this.m_registry.get(unsignedShort);
        if (zipEntryCompressionMethodFactory == null) {
            throw new UnknownZipEntryCompressionMethodException("No Zip entry compression method factory is registered for the code " + unsignedShort);
        }
        return zipEntryCompressionMethodFactory;
    }
}

