/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.util.Date;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;

public class ExtendedTimestampExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(21589);
    private final boolean m_inLocalHeader;
    private final Date m_lastModificationTime;
    private final Date m_lastAccessTime;
    private final Date m_originalCreationTime;

    public ExtendedTimestampExtraField(boolean bl, Date date, Date date2, Date date3) {
        this.m_inLocalHeader = bl;
        this.m_lastModificationTime = date != null ? new Date(date.getTime()) : null;
        this.m_lastAccessTime = date2 != null ? new Date(date2.getTime()) : null;
        this.m_originalCreationTime = date3 != null ? new Date(date3.getTime()) : null;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public Date getLastModified() {
        return this.m_lastModificationTime != null ? new Date(this.m_lastModificationTime.getTime()) : null;
    }

    public Date getLastAccessed() {
        return this.m_lastAccessTime != null ? new Date(this.m_lastAccessTime.getTime()) : null;
    }

    public Date getOriginalCreationTime() {
        return this.m_originalCreationTime != null ? new Date(this.m_originalCreationTime.getTime()) : null;
    }

    private boolean datesEqual(Date date, Date date2) {
        return date != null ? date.equals(date2) : date2 == null;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ExtendedTimestampExtraField) {
            ExtendedTimestampExtraField extendedTimestampExtraField = (ExtendedTimestampExtraField)object;
            return this.m_inLocalHeader == extendedTimestampExtraField.isInLocalHeader() && this.datesEqual(this.m_lastModificationTime, extendedTimestampExtraField.m_lastModificationTime) && this.datesEqual(this.m_lastAccessTime, extendedTimestampExtraField.m_lastAccessTime) && this.datesEqual(this.m_originalCreationTime, extendedTimestampExtraField.m_originalCreationTime);
        }
        return false;
    }

    public int hashCode() {
        int n = this.m_inLocalHeader ? 1 : 0;
        n = 17 * n + (this.m_lastModificationTime != null ? this.m_lastModificationTime.hashCode() : 0);
        n = 17 * n + (this.m_lastAccessTime != null ? this.m_lastAccessTime.hashCode() : 0);
        return 17 * n + (this.m_originalCreationTime != null ? this.m_originalCreationTime.hashCode() : 0);
    }

    public String toString() {
        return (this.m_inLocalHeader ? "l " : "") + "last mod time: " + (this.m_lastModificationTime != null ? this.m_lastModificationTime : "<null>") + ", last access time: " + (this.m_lastAccessTime != null ? this.m_lastAccessTime : "<null>") + ", original creation time: " + (this.m_originalCreationTime != null ? this.m_originalCreationTime : "<null>");
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        byte[] byArray;
        int n = 1;
        int n2 = 0;
        if (this.m_lastModificationTime != null) {
            n2 = 1;
            n = 5;
        }
        if (this.m_lastAccessTime != null) {
            n2 = (byte)(n2 + 2);
            n += 4;
        }
        if (this.m_originalCreationTime != null) {
            n2 = (byte)(n2 + 4);
            n += 4;
        }
        byte[] byArray2 = new byte[n];
        byArray2[0] = n2;
        int n3 = 1;
        if (this.m_lastModificationTime != null) {
            byArray = UnsignedInteger.valueOf(this.m_lastModificationTime.getTime() / 1000L).getBigEndianByteArray();
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        if (this.m_lastAccessTime != null) {
            byArray = UnsignedInteger.valueOf(this.m_lastAccessTime.getTime() / 1000L).getBigEndianByteArray();
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        if (this.m_originalCreationTime != null) {
            byArray = UnsignedInteger.valueOf(this.m_originalCreationTime.getTime() / 1000L).getBigEndianByteArray();
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
        }
        return byArray2;
    }
}

