/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.util.Date;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;

public class InfoZipUnixExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(22613);
    private final boolean m_inLocalHeader;
    private final Date m_lastAccessTime;
    private final Date m_lastModificationTime;
    private final UnsignedShort m_uid;
    private final UnsignedShort m_gid;

    public InfoZipUnixExtraField(Date date, Date date2) {
        date.getClass();
        date2.getClass();
        this.m_inLocalHeader = false;
        this.m_lastAccessTime = (Date)date.clone();
        this.m_lastModificationTime = (Date)date2.clone();
        this.m_uid = null;
        this.m_gid = null;
    }

    public InfoZipUnixExtraField(Date date, Date date2, UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        date.getClass();
        date2.getClass();
        unsignedShort.getClass();
        unsignedShort2.getClass();
        this.m_inLocalHeader = true;
        this.m_lastAccessTime = (Date)date.clone();
        this.m_lastModificationTime = (Date)date2.clone();
        this.m_uid = unsignedShort;
        this.m_gid = unsignedShort2;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public UnsignedShort getUid() {
        return this.m_uid;
    }

    public UnsignedShort getGid() {
        return this.m_gid;
    }

    public Date getLastAccessTime() {
        return (Date)this.m_lastAccessTime.clone();
    }

    public Date getLastModificationTime() {
        return (Date)this.m_lastModificationTime.clone();
    }

    public String toString() {
        return "Unix - uid: " + (this.m_uid != null ? this.m_uid : "<null>") + ", gid: " + (this.m_gid != null ? this.m_gid : "<null>") + ", last access time: " + this.m_lastAccessTime + ", last modification time: " + this.m_lastModificationTime;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof InfoZipUnixExtraField) {
            InfoZipUnixExtraField infoZipUnixExtraField = (InfoZipUnixExtraField)object;
            if (this.m_inLocalHeader ^ infoZipUnixExtraField.m_inLocalHeader) {
                return false;
            }
            if (!this.m_lastAccessTime.equals(infoZipUnixExtraField.m_lastAccessTime) || !this.m_lastModificationTime.equals(infoZipUnixExtraField.m_lastModificationTime)) {
                return false;
            }
            if (this.m_inLocalHeader && infoZipUnixExtraField.m_inLocalHeader) {
                return this.m_uid.equals(infoZipUnixExtraField.m_uid) && this.m_gid.equals(infoZipUnixExtraField.m_gid);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.m_lastAccessTime.hashCode();
        n = 17 * n + this.m_lastModificationTime.hashCode();
        return this.m_inLocalHeader ? 17 * n + this.m_uid.intValue() << 16 + this.m_gid.intValue() : n;
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        if (this.m_inLocalHeader) {
            byArray3 = new byte[12];
            byArray2 = this.m_uid.getBigEndianByteArray();
            byArray3[8] = byArray2[0];
            byArray3[9] = byArray2[1];
            byArray = this.m_gid.getBigEndianByteArray();
            byArray3[10] = byArray[0];
            byArray3[11] = byArray[1];
        } else {
            byArray3 = new byte[8];
        }
        byArray2 = UnsignedInteger.valueOf(this.m_lastAccessTime.getTime() / 1000L).getBigEndianByteArray();
        byArray3[0] = byArray2[0];
        byArray3[1] = byArray2[1];
        byArray3[2] = byArray2[2];
        byArray3[3] = byArray2[3];
        byArray = UnsignedInteger.valueOf(this.m_lastModificationTime.getTime() / 1000L).getBigEndianByteArray();
        byArray3[4] = byArray[0];
        byArray3[5] = byArray[1];
        byArray3[6] = byArray[2];
        byArray3[7] = byArray[3];
        return byArray3;
    }
}

