/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.util.Date;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ef.InfoZipUnixExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldParser;

public class InfoZipUnixExtraFieldParser
implements ZipEntryExtraFieldParser {
    public static final InfoZipUnixExtraFieldParser INSTANCE = new InfoZipUnixExtraFieldParser();

    public UnsignedShort getCode() {
        return InfoZipUnixExtraField.CODE;
    }

    public InfoZipUnixExtraField parse(byte[] byArray, boolean bl) {
        if (bl) {
            if (byArray.length != 12) {
                throw new ZipFileParseException("Could not create a local header extra field from a byte array that is " + byArray.length + " bytes long. Expected 12 bytes.");
            }
            UnsignedInteger unsignedInteger = UnsignedInteger.fromBigEndianByteArray(byArray, 0);
            UnsignedInteger unsignedInteger2 = UnsignedInteger.fromBigEndianByteArray(byArray, 4);
            UnsignedShort unsignedShort = UnsignedShort.fromBigEndianByteArray(byArray, 8);
            UnsignedShort unsignedShort2 = UnsignedShort.fromBigEndianByteArray(byArray, 10);
            return new InfoZipUnixExtraField(new Date(unsignedInteger.longValue() * 1000L), new Date(unsignedInteger2.longValue() * 1000L), unsignedShort, unsignedShort2);
        }
        if (byArray.length != 8) {
            throw new ZipFileParseException("Could not create a central header extra field from a byte array that is " + byArray.length + " bytes long. Expected 8 bytes.");
        }
        UnsignedInteger unsignedInteger = UnsignedInteger.fromBigEndianByteArray(byArray, 0);
        UnsignedInteger unsignedInteger3 = UnsignedInteger.fromBigEndianByteArray(byArray, 4);
        return new InfoZipUnixExtraField(new Date(unsignedInteger.longValue() * 1000L), new Date(unsignedInteger3.longValue() * 1000L));
    }
}

