/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;

public class NewInfoZipUnixExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(30805);
    public static final NewInfoZipUnixExtraField CENTRAL_HEADER_VERSION = new NewInfoZipUnixExtraField();
    private final boolean m_inLocalHeader;
    private final UnsignedShort m_uid;
    private final UnsignedShort m_gid;

    private NewInfoZipUnixExtraField() {
        this.m_inLocalHeader = false;
        this.m_uid = null;
        this.m_gid = null;
    }

    public NewInfoZipUnixExtraField(UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        unsignedShort.getClass();
        unsignedShort2.getClass();
        this.m_inLocalHeader = true;
        this.m_uid = unsignedShort;
        this.m_gid = unsignedShort2;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public UnsignedShort getUid() {
        return this.m_uid;
    }

    public UnsignedShort getGid() {
        return this.m_gid;
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        if (this.m_inLocalHeader) {
            byte[] byArray = new byte[4];
            byte[] byArray2 = this.m_uid.getBigEndianByteArray();
            byArray[0] = byArray2[0];
            byArray[1] = byArray2[1];
            byte[] byArray3 = this.m_gid.getBigEndianByteArray();
            byArray[2] = byArray3[0];
            byArray[3] = byArray3[1];
            return byArray;
        }
        return new byte[0];
    }

    public String toString() {
        return "Unix2 - uid: " + (this.m_uid != null ? this.m_uid : "<null>") + ", gid: " + (this.m_gid != null ? this.m_gid : "<null>");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NewInfoZipUnixExtraField) {
            NewInfoZipUnixExtraField newInfoZipUnixExtraField = (NewInfoZipUnixExtraField)object;
            if (!this.m_inLocalHeader && !newInfoZipUnixExtraField.m_inLocalHeader) {
                return true;
            }
            if (this.m_inLocalHeader && newInfoZipUnixExtraField.m_inLocalHeader) {
                return this.m_uid.equals(newInfoZipUnixExtraField.m_uid) && this.m_gid.equals(newInfoZipUnixExtraField.m_gid);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_uid != null ? this.m_uid.intValue() << 16 + this.m_gid.intValue() : 0;
    }
}

