/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.util.WinNtTime;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;

public class NtfsExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(10);
    private static final byte[] TAG1 = UnsignedShort.valueOf(1).getBigEndianByteArray();
    private static final byte[] TAG1_SIZE = UnsignedShort.valueOf(24).getBigEndianByteArray();
    private final boolean m_inLocalHeader;
    private final WinNtTime m_lastModificationTime;
    private final WinNtTime m_lastAccessTime;
    private final WinNtTime m_creationTime;

    public NtfsExtraField(boolean bl, WinNtTime winNtTime, WinNtTime winNtTime2, WinNtTime winNtTime3) {
        winNtTime.getClass();
        winNtTime2.getClass();
        winNtTime3.getClass();
        this.m_inLocalHeader = bl;
        this.m_lastModificationTime = winNtTime;
        this.m_lastAccessTime = winNtTime2;
        this.m_creationTime = winNtTime3;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public WinNtTime getLastModified() {
        return this.m_lastModificationTime;
    }

    public WinNtTime getCreationTime() {
        return this.m_creationTime;
    }

    public WinNtTime getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        byte[] byArray = new byte[32];
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = TAG1[0];
        byArray[5] = TAG1[1];
        byArray[6] = TAG1_SIZE[0];
        byArray[7] = TAG1_SIZE[1];
        System.arraycopy(this.m_lastModificationTime.getTime().getBigEndianByteArray(), 0, byArray, 8, 8);
        System.arraycopy(this.m_lastAccessTime.getTime().getBigEndianByteArray(), 0, byArray, 16, 8);
        System.arraycopy(this.m_creationTime.getTime().getBigEndianByteArray(), 0, byArray, 24, 8);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NtfsExtraField) {
            NtfsExtraField ntfsExtraField = (NtfsExtraField)object;
            return this.m_inLocalHeader == ntfsExtraField.m_inLocalHeader && this.m_lastModificationTime.equals(ntfsExtraField.m_lastModificationTime) && this.m_lastAccessTime.equals(ntfsExtraField.m_lastAccessTime) && this.m_creationTime.equals(ntfsExtraField.m_creationTime);
        }
        return false;
    }

    public int hashCode() {
        int n = this.m_lastModificationTime.hashCode();
        n = this.m_lastAccessTime.hashCode() + 17 * n;
        n = this.m_creationTime.hashCode() + 17 * n;
        return this.m_inLocalHeader ? n + 1 : n;
    }

    public String toString() {
        return "NTFS extra field in " + (this.m_inLocalHeader ? "local" : "central") + " file header: Last mod time " + this.m_lastModificationTime + ", last access time " + this.m_lastAccessTime + ", creation time " + this.m_creationTime;
    }
}

