/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import org.at4j.support.lang.UnsignedLong;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.util.WinNtTime;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ef.NtfsExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldParser;

public class NtfsExtraFieldParser
implements ZipEntryExtraFieldParser {
    public static final NtfsExtraFieldParser INSTANCE = new NtfsExtraFieldParser();

    public UnsignedShort getCode() {
        return NtfsExtraField.CODE;
    }

    public NtfsExtraField parse(byte[] byArray, boolean bl) throws ZipFileParseException {
        int n = 4;
        UnsignedShort unsignedShort = UnsignedShort.fromBigEndianByteArray(byArray, n);
        if (unsignedShort.intValue() != 1) {
            throw new ZipFileParseException("Illegal value " + unsignedShort + " for Tag1 in an NTFS extra field. It must be 1");
        }
        UnsignedShort unsignedShort2 = UnsignedShort.fromBigEndianByteArray(byArray, n += 2);
        if (unsignedShort2.intValue() != 24) {
            throw new ZipFileParseException("Illegal value " + unsignedShort2 + " for Tag1 size in an NTFS extra field. It must be 24");
        }
        WinNtTime winNtTime = new WinNtTime(UnsignedLong.fromBigEndianByteArray(byArray, n += 2));
        WinNtTime winNtTime2 = new WinNtTime(UnsignedLong.fromBigEndianByteArray(byArray, n += 8));
        WinNtTime winNtTime3 = new WinNtTime(UnsignedLong.fromBigEndianByteArray(byArray, n += 8));
        return new NtfsExtraField(bl, winNtTime, winNtTime2, winNtTime3);
    }
}

