/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.nio.charset.Charset;
import java.util.zip.CRC32;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;

public class UnicodeCommentExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(25461);
    private final boolean m_inLocalHeader;
    private final String m_comment;

    public UnicodeCommentExtraField(boolean bl, String string) {
        this.m_inLocalHeader = bl;
        this.m_comment = string;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public String getComment() {
        return this.m_comment != null ? this.m_comment : "";
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        byte[] byArray = this.m_comment == null || this.m_comment.length() == 0 ? new byte[]{} : Charsets.getBytes(this.m_comment, Charsets.UTF8);
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 1;
        Charset charset = zipBuilderConfiguration.getTextEncodingCharset();
        byte[] byArray3 = byArray.length == 0 || charset.equals(Charsets.UTF8) ? byArray : Charsets.getBytes(this.m_comment, charset);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3);
        byte[] byArray4 = UnsignedInteger.valueOf(cRC32.getValue()).getBigEndianByteArray();
        byArray2[1] = byArray4[0];
        byArray2[2] = byArray4[1];
        byArray2[3] = byArray4[2];
        byArray2[4] = byArray4[3];
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        return byArray2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnicodeCommentExtraField) {
            UnicodeCommentExtraField unicodeCommentExtraField = (UnicodeCommentExtraField)object;
            return this.m_inLocalHeader == unicodeCommentExtraField.m_inLocalHeader && this.m_comment.equals(unicodeCommentExtraField.m_comment);
        }
        return false;
    }

    public int hashCode() {
        return this.m_comment.hashCode() + (this.m_inLocalHeader ? 1 : 0);
    }

    public String toString() {
        return this.m_comment;
    }
}

