/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ef.UnicodeCommentExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldParser;

public class UnicodeCommentExtraFieldParser
implements ZipEntryExtraFieldParser {
    public static final UnicodeCommentExtraFieldParser INSTANCE = new UnicodeCommentExtraFieldParser();

    public UnsignedShort getCode() {
        return UnicodeCommentExtraField.CODE;
    }

    public UnicodeCommentExtraField parse(byte[] byArray, boolean bl) {
        if (byArray.length < 5) {
            throw new ZipFileParseException("Invalid data in unicode comment extra field: It was only " + byArray.length + " bytes long");
        }
        if (byArray.length == 5) {
            return new UnicodeCommentExtraField(bl, null);
        }
        CharBuffer charBuffer = Charsets.UTF8.decode(ByteBuffer.wrap(byArray, 5, byArray.length - 5));
        char[] cArray = new char[charBuffer.limit()];
        charBuffer.get(cArray);
        return new UnicodeCommentExtraField(bl, new String(cArray));
    }
}

