/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.nio.charset.Charset;
import java.util.zip.CRC32;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.zip.builder.ZipBuilderConfiguration;
import org.at4j.zip.ef.ZipEntryExtraField;
import org.entityfs.el.AbsoluteLocation;

public class UnicodePathExtraField
implements ZipEntryExtraField {
    public static final UnsignedShort CODE = UnsignedShort.valueOf(28789);
    private final boolean m_inLocalHeader;
    private final AbsoluteLocation m_absolutePath;
    private final boolean m_directory;

    public UnicodePathExtraField(boolean bl, AbsoluteLocation absoluteLocation, boolean bl2) {
        absoluteLocation.getClass();
        this.m_inLocalHeader = bl;
        this.m_absolutePath = absoluteLocation;
        this.m_directory = bl2;
    }

    public boolean isInLocalHeader() {
        return this.m_inLocalHeader;
    }

    public AbsoluteLocation getAbsolutePath() {
        return this.m_absolutePath;
    }

    public boolean isDirectory() {
        return this.m_directory;
    }

    public byte[] encode(ZipBuilderConfiguration zipBuilderConfiguration) {
        String string = this.m_absolutePath.getLocation().substring(1).replace('/', '\\');
        if (this.m_directory) {
            string = string + '\\';
        }
        byte[] byArray = Charsets.getBytes(string, Charsets.UTF8);
        byte[] byArray2 = new byte[5 + byArray.length];
        byArray2[0] = 1;
        Charset charset = zipBuilderConfiguration.getFileNameEncodingCharset();
        byte[] byArray3 = charset.equals(Charsets.UTF8) ? byArray : Charsets.getBytes(string, charset);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3);
        byte[] byArray4 = UnsignedInteger.valueOf(cRC32.getValue()).getBigEndianByteArray();
        byArray2[1] = byArray4[0];
        byArray2[2] = byArray4[1];
        byArray2[3] = byArray4[2];
        byArray2[4] = byArray4[3];
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        return byArray2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnicodePathExtraField) {
            UnicodePathExtraField unicodePathExtraField = (UnicodePathExtraField)object;
            return this.m_inLocalHeader == unicodePathExtraField.m_inLocalHeader && this.m_directory == unicodePathExtraField.m_directory && this.m_absolutePath.equals((Object)unicodePathExtraField.m_absolutePath);
        }
        return false;
    }

    public int hashCode() {
        return this.m_absolutePath.hashCode() + (this.m_inLocalHeader ? 1 : 0) + (this.m_directory ? 1 : 0);
    }

    public String toString() {
        return this.m_absolutePath.toString();
    }
}

