/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.ef;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.at4j.support.lang.UnsignedShort;
import org.at4j.support.nio.charset.Charsets;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ef.UnicodePathExtraField;
import org.at4j.zip.ef.ZipEntryExtraFieldParser;
import org.entityfs.el.AbsoluteLocation;

public class UnicodePathExtraFieldParser
implements ZipEntryExtraFieldParser {
    public static final UnicodePathExtraFieldParser INSTANCE = new UnicodePathExtraFieldParser();

    public UnsignedShort getCode() {
        return UnicodePathExtraField.CODE;
    }

    public UnicodePathExtraField parse(byte[] byArray, boolean bl) {
        if (byArray.length < 5) {
            throw new ZipFileParseException("Invalid data in unicode path extra field: It was only " + byArray.length + " bytes long");
        }
        CharBuffer charBuffer = Charsets.UTF8.decode(ByteBuffer.wrap(byArray, 5, byArray.length - 5));
        char[] cArray = new char[charBuffer.limit()];
        int n = cArray.length;
        charBuffer.get(cArray);
        boolean bl2 = cArray[n - 1] == '\\';
        String string = bl2 ? new String(cArray, 0, n - 1) : new String(cArray);
        return new UnicodePathExtraField(bl, new AbsoluteLocation("/" + string.replace('\\', '/')), bl2);
    }
}

