/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.EnumSet;
import java.util.Set;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.MsDosFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsDosExternalFileAttributes
implements ZipExternalFileAttributes {
    public static final MsDosExternalFileAttributes DEFAULT_DIRECTORY_ATTRIBUTES = new MsDosExternalFileAttributes(MsDosFileAttributes.SUB_DIRECTORY);
    public static final MsDosExternalFileAttributes DEFAULT_FILE_ATTRIBUTES = new MsDosExternalFileAttributes(MsDosFileAttributes.ARCHIVE);
    private final EnumSet<MsDosFileAttributes> m_attributes;

    public MsDosExternalFileAttributes(MsDosFileAttributes ... msDosFileAttributesArray) {
        this.m_attributes = EnumSet.noneOf(MsDosFileAttributes.class);
        for (MsDosFileAttributes msDosFileAttributes : msDosFileAttributesArray) {
            this.m_attributes.add(msDosFileAttributes);
        }
    }

    public MsDosExternalFileAttributes(Set<MsDosFileAttributes> set) {
        this.m_attributes = EnumSet.copyOf(set);
    }

    @Override
    public ZipVersionMadeBy getVersionMadeBy() {
        return ZipVersionMadeBy.MSDOS;
    }

    public Set<MsDosFileAttributes> getAttributes() {
        return this.m_attributes.clone();
    }

    public boolean isSet(MsDosFileAttributes msDosFileAttributes) {
        return this.m_attributes.contains((Object)msDosFileAttributes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MsDosExternalFileAttributes) {
            return this.m_attributes.equals(((MsDosExternalFileAttributes)object).m_attributes);
        }
        return false;
    }

    public int hashCode() {
        return this.m_attributes.hashCode();
    }

    public String toString() {
        return "MS DOS external file attributes " + this.m_attributes;
    }

    @Override
    public UnsignedInteger getEncodedValue() {
        int n = 0;
        for (MsDosFileAttributes msDosFileAttributes : this.m_attributes) {
            n += msDosFileAttributes.getEncodedValue();
        }
        return UnsignedInteger.valueOf(n);
    }
}

