/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.EnumSet;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.MsDosExternalFileAttributes;
import org.at4j.zip.extattrs.MsDosFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributesParser;

public class MsDosExternalFileAttributesParser
implements ZipExternalFileAttributesParser {
    public static final MsDosExternalFileAttributesParser INSTANCE = new MsDosExternalFileAttributesParser();

    public ZipVersionMadeBy getVersionMadeBy() {
        return ZipVersionMadeBy.MSDOS;
    }

    public MsDosExternalFileAttributes parse(ZipVersionMadeBy zipVersionMadeBy, byte[] byArray) {
        if (zipVersionMadeBy != ZipVersionMadeBy.MSDOS) {
            throw new ZipFileParseException("Expected version made by " + (Object)((Object)ZipVersionMadeBy.MSDOS) + ". Was " + (Object)((Object)zipVersionMadeBy));
        }
        if (byArray.length != 4) {
            throw new ZipFileParseException("Invalid Zip file. This attributes parser requires 4 bytes. Got " + byArray.length);
        }
        byte by = byArray[0];
        EnumSet<MsDosFileAttributes> enumSet = EnumSet.noneOf(MsDosFileAttributes.class);
        for (MsDosFileAttributes msDosFileAttributes : MsDosFileAttributes.ALL) {
            if ((by & msDosFileAttributes.getEncodedValue()) <= 0) continue;
            enumSet.add(msDosFileAttributes);
        }
        return new MsDosExternalFileAttributes(enumSet);
    }
}

