/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.EnumSet;
import java.util.Set;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.NtfsFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtfsExternalFileAttributes
implements ZipExternalFileAttributes {
    public static final NtfsExternalFileAttributes DEFAULT_FILE_ATTRIBUTES = new NtfsExternalFileAttributes(NtfsFileAttributes.ARCHIVE);
    public static final NtfsExternalFileAttributes DEFAULT_DIRECTORY_ATTRIBUTES = new NtfsExternalFileAttributes(NtfsFileAttributes.ARCHIVE);
    private final EnumSet<NtfsFileAttributes> m_attributes;

    public NtfsExternalFileAttributes(NtfsFileAttributes ... ntfsFileAttributesArray) {
        this.m_attributes = EnumSet.noneOf(NtfsFileAttributes.class);
        for (NtfsFileAttributes ntfsFileAttributes : ntfsFileAttributesArray) {
            this.m_attributes.add(ntfsFileAttributes);
        }
    }

    public NtfsExternalFileAttributes(Set<NtfsFileAttributes> set) {
        this.m_attributes = EnumSet.copyOf(set);
    }

    public EnumSet<NtfsFileAttributes> getAttributes() {
        return this.m_attributes.clone();
    }

    @Override
    public ZipVersionMadeBy getVersionMadeBy() {
        return ZipVersionMadeBy.WINDOWS_NTFS;
    }

    public boolean isSet(NtfsFileAttributes ntfsFileAttributes) {
        return this.m_attributes.contains((Object)ntfsFileAttributes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NtfsExternalFileAttributes) {
            return this.m_attributes.equals(((NtfsExternalFileAttributes)object).m_attributes);
        }
        return false;
    }

    public int hashCode() {
        return this.m_attributes.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("NTFS file attributes (");
        for (NtfsFileAttributes ntfsFileAttributes : this.m_attributes) {
            stringBuilder.append(ntfsFileAttributes.toString()).append(", ");
        }
        return stringBuilder.append(")").toString();
    }

    @Override
    public UnsignedInteger getEncodedValue() {
        int n = 0;
        for (NtfsFileAttributes ntfsFileAttributes : this.m_attributes) {
            n += ntfsFileAttributes.getCode();
        }
        return UnsignedInteger.valueOf(n);
    }
}

