/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.EnumSet;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.NtfsExternalFileAttributes;
import org.at4j.zip.extattrs.NtfsFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributesParser;

public class NtfsExternalFileAttributesParser
implements ZipExternalFileAttributesParser {
    public static final NtfsExternalFileAttributesParser INSTANCE = new NtfsExternalFileAttributesParser();

    public ZipVersionMadeBy getVersionMadeBy() {
        return ZipVersionMadeBy.WINDOWS_NTFS;
    }

    public NtfsExternalFileAttributes parse(ZipVersionMadeBy zipVersionMadeBy, byte[] byArray) {
        if (byArray.length != 4) {
            throw new ZipFileParseException("Invalid Zip file. This parser requires 4 bytes. Got " + byArray.length);
        }
        int n = UnsignedInteger.fromBigEndianByteArray(byArray).intValue();
        EnumSet<NtfsFileAttributes> enumSet = EnumSet.noneOf(NtfsFileAttributes.class);
        for (NtfsFileAttributes ntfsFileAttributes : NtfsFileAttributes.ALL) {
            if ((n & ntfsFileAttributes.getCode()) <= 0) continue;
            enumSet.add(ntfsFileAttributes);
        }
        return new NtfsExternalFileAttributes(enumSet);
    }
}

