/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UnixEntityType {
    REGULAR_FILE('-', 8),
    DIRECTORY('d', 4),
    SYMBOLIC_LINK('l', 10),
    BLOCK_SPECIAL('b', 6),
    CHARACTER_SPECIAL('c', 2),
    PIPE('p', 1),
    SOCKET('s', 12);

    private final char m_character;
    private final byte m_code;

    private UnixEntityType(char c, int n2) {
        this.m_character = c;
        this.m_code = (byte)n2;
    }

    public static UnixEntityType forCode(int n) throws IllegalArgumentException {
        switch (n) {
            case 8: {
                return REGULAR_FILE;
            }
            case 4: {
                return DIRECTORY;
            }
            case 10: {
                return SYMBOLIC_LINK;
            }
            case 6: {
                return BLOCK_SPECIAL;
            }
            case 2: {
                return CHARACTER_SPECIAL;
            }
            case 1: {
                return PIPE;
            }
            case 12: {
                return SOCKET;
            }
        }
        throw new IllegalArgumentException("Unknown entity type code " + n);
    }

    public byte getCode() {
        return this.m_code;
    }

    public String toString() {
        return "" + this.m_character;
    }
}

