/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import org.at4j.support.lang.UnsignedShort;
import org.at4j.zip.ZipFileParseException;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.UnixEntityType;
import org.at4j.zip.extattrs.UnixExternalFileAttributes;
import org.at4j.zip.extattrs.ZipExternalFileAttributesParser;
import org.entityfs.entityattrs.unix.UnixEntityMode;

public class UnixExternalFileAttributesParser
implements ZipExternalFileAttributesParser {
    public static final UnixExternalFileAttributesParser INSTANCE = new UnixExternalFileAttributesParser();

    public ZipVersionMadeBy getVersionMadeBy() {
        return ZipVersionMadeBy.UNIX;
    }

    public UnixExternalFileAttributes parse(ZipVersionMadeBy zipVersionMadeBy, byte[] byArray) {
        if (zipVersionMadeBy != ZipVersionMadeBy.UNIX) {
            throw new ZipFileParseException("Expected version made by " + (Object)((Object)ZipVersionMadeBy.UNIX) + ". Was " + (Object)((Object)zipVersionMadeBy));
        }
        if (byArray.length != 4) {
            throw new ZipFileParseException("Invalid Zip file. This parser requires 4 bytes. Got " + byArray.length);
        }
        int n = UnsignedShort.fromBigEndianByteArray(byArray, 2).intValue();
        int n2 = n >> 12 & 0xF;
        UnixEntityType unixEntityType = n2 != 0 ? UnixEntityType.forCode(n2) : UnixEntityType.DIRECTORY;
        int n3 = n & 0xFFF;
        UnixEntityMode unixEntityMode = n3 != 0 ? UnixEntityMode.forCode((int)n3) : UnixEntityMode.forCode((int)509);
        return new UnixExternalFileAttributes(unixEntityType, unixEntityMode);
    }
}

