/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.Arrays;
import org.at4j.support.lang.UnsignedInteger;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.ZipExternalFileAttributes;

public class UnparsedExternalFileAttributes
implements ZipExternalFileAttributes {
    private final ZipVersionMadeBy m_versionMadeBy;
    private final byte[] m_externalFileAttributes;

    public UnparsedExternalFileAttributes(ZipVersionMadeBy zipVersionMadeBy, byte[] byArray) {
        ((Object)((Object)zipVersionMadeBy)).getClass();
        byArray.getClass();
        if (byArray.length != 4) {
            throw new IllegalArgumentException("The byte array must be four bytes long. Was " + byArray.length);
        }
        this.m_versionMadeBy = zipVersionMadeBy;
        this.m_externalFileAttributes = byArray;
    }

    public ZipVersionMadeBy getVersionMadeBy() {
        return this.m_versionMadeBy;
    }

    public byte[] getUnparsedExternalFileAttributes() {
        byte[] byArray = new byte[4];
        System.arraycopy(this.m_externalFileAttributes, 0, byArray, 0, 4);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UnparsedExternalFileAttributes) {
            return this.m_versionMadeBy == ((UnparsedExternalFileAttributes)object).m_versionMadeBy && Arrays.equals(this.m_externalFileAttributes, ((UnparsedExternalFileAttributes)object).m_externalFileAttributes);
        }
        return false;
    }

    public int hashCode() {
        return 30 * UnsignedInteger.fromBigEndianByteArray(this.m_externalFileAttributes).intValue() + this.m_versionMadeBy.ordinal();
    }

    public String toString() {
        return this.m_versionMadeBy.toString() + ": " + UnsignedInteger.fromBigEndianByteArray(this.m_externalFileAttributes).toString();
    }

    public UnsignedInteger getEncodedValue() {
        return UnsignedInteger.fromBigEndianByteArray(this.m_externalFileAttributes);
    }
}

