/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.extattrs;

import java.util.HashMap;
import java.util.Map;
import org.at4j.zip.ZipVersionMadeBy;
import org.at4j.zip.extattrs.MsDosExternalFileAttributesParser;
import org.at4j.zip.extattrs.NtfsExternalFileAttributesParser;
import org.at4j.zip.extattrs.UnixExternalFileAttributesParser;
import org.at4j.zip.extattrs.UnparsedExternalFileAttributesParser;
import org.at4j.zip.extattrs.ZipExternalFileAttributesParser;

public class ZipExternalFileAttributesParserRegistry {
    private final Map<ZipVersionMadeBy, ZipExternalFileAttributesParser> m_registry = new HashMap<ZipVersionMadeBy, ZipExternalFileAttributesParser>();

    public ZipExternalFileAttributesParserRegistry() {
        this.m_registry.put(ZipVersionMadeBy.MSDOS, MsDosExternalFileAttributesParser.INSTANCE);
        this.m_registry.put(ZipVersionMadeBy.UNIX, UnixExternalFileAttributesParser.INSTANCE);
        this.m_registry.put(ZipVersionMadeBy.WINDOWS_NTFS, NtfsExternalFileAttributesParser.INSTANCE);
    }

    public void registerExternalFileAttributesParser(ZipExternalFileAttributesParser zipExternalFileAttributesParser) {
        this.m_registry.put(zipExternalFileAttributesParser.getVersionMadeBy(), zipExternalFileAttributesParser);
    }

    public ZipExternalFileAttributesParser forVersionMadeBy(ZipVersionMadeBy zipVersionMadeBy) {
        ZipExternalFileAttributesParser zipExternalFileAttributesParser = this.m_registry.get((Object)zipVersionMadeBy);
        return zipExternalFileAttributesParser != null ? zipExternalFileAttributesParser : UnparsedExternalFileAttributesParser.INSTANCE;
    }
}

