/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.prog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.at4j.support.prog.AbstractProgram;
import org.at4j.support.prog.CommandErrorException;
import org.at4j.zip.ZipDirectoryEntry;
import org.at4j.zip.ZipEntry;
import org.at4j.zip.ZipFile;
import org.at4j.zip.ZipFileEntry;
import org.at4j.zip.prog.UnzipCommandLineArguments;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;
import org.entityfs.util.io.ReadWritableFileAdapter;

public final class Unzip
extends AbstractProgram {
    private UnzipCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        UnzipCommandLineArguments unzipCommandLineArguments = new UnzipCommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing file");
        while (this.isFlagArgument(string)) {
            if ("--timing".equals(string)) {
                unzipCommandLineArguments.setTiming();
            } else if ("-q".equals(string)) {
                unzipCommandLineArguments.setQuiet();
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        unzipCommandLineArguments.setZipFile(new File(string));
        if (n < stringArray.length) {
            throw new CommandErrorException("Cannot handle files argument");
        }
        return unzipCommandLineArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFile(ZipFileEntry zipFileEntry, UnzipCommandLineArguments unzipCommandLineArguments) throws CommandErrorException, IOException {
        File file;
        String string = zipFileEntry.getLocation().getLocation().substring(1);
        if (!unzipCommandLineArguments.isQuiet()) {
            System.out.println(string);
        }
        if (!(file = new File(string)).createNewFile()) {
            throw new CommandErrorException("Could not create file " + file);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFileEntry.openForRead());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                StreamUtil.copyStreams((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream, (int)4096, (long)zipFileEntry.getDataSize());
            }
            catch (WrappedIOException wrappedIOException) {
                throw wrappedIOException.getWrapped();
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        if (!file.setLastModified(zipFileEntry.getLastModified().getTime())) {
            System.err.println("Could not set last modification time for file " + file);
        }
    }

    private void extractDirectory(ZipDirectoryEntry zipDirectoryEntry, UnzipCommandLineArguments unzipCommandLineArguments) throws CommandErrorException, IOException {
        String string = zipDirectoryEntry.getLocation().getLocation().substring(1);
        if (!unzipCommandLineArguments.isQuiet()) {
            System.out.println(string);
        }
        File file = new File(string);
        if (!"".equals(string) && !file.mkdir()) {
            throw new CommandErrorException("Could not create directory " + file);
        }
        for (ZipEntry zipEntry : zipDirectoryEntry.getChildEntries().values()) {
            if (zipEntry instanceof ZipDirectoryEntry) {
                this.extractDirectory((ZipDirectoryEntry)zipEntry, unzipCommandLineArguments);
                continue;
            }
            if (zipEntry instanceof ZipFileEntry) {
                this.extractFile((ZipFileEntry)zipEntry, unzipCommandLineArguments);
                continue;
            }
            throw new CommandErrorException("Unknown entry type " + zipEntry);
        }
        if (!file.setLastModified(zipDirectoryEntry.getLastModified().getTime())) {
            System.err.println("Could not set last modification time for directory " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray) throws CommandErrorException, IOException {
        UnzipCommandLineArguments unzipCommandLineArguments = this.parseCommandLine(stringArray);
        long l = System.currentTimeMillis();
        ZipFile zipFile = new ZipFile((RandomlyAccessibleFile)new ReadWritableFileAdapter(unzipCommandLineArguments.getZipFile()));
        try {
            this.extractDirectory(zipFile.getRootEntry(), unzipCommandLineArguments);
        }
        finally {
            zipFile.close();
        }
        long l2 = System.currentTimeMillis();
        if (unzipCommandLineArguments.isTiming()) {
            System.out.println("The operation took " + (l2 - l) + " ms.");
            System.out.println("The time it took to load Java and start the program is not included.");
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Unzip().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            commandErrorException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

