/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.support.prog.AbstractProgram;
import org.at4j.support.prog.CommandErrorException;
import org.at4j.zip.builder.ZipBuilder;
import org.at4j.zip.prog.ZipCommandLineArguments;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.util.io.ReadWritableFileAdapter;

public final class Zip
extends AbstractProgram {
    private ZipCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        ZipCommandLineArguments zipCommandLineArguments = new ZipCommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("-r".equals(string)) {
                zipCommandLineArguments.setRecursive();
            } else if ("--timing".equals(string)) {
                zipCommandLineArguments.setTiming();
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        zipCommandLineArguments.setTargetFile(new File(string));
        zipCommandLineArguments.addFileToZip(new File(this.getArg(stringArray, n++, "Missing files to zip")));
        while (n < stringArray.length) {
            zipCommandLineArguments.addFileToZip(new File(stringArray[n++]));
        }
        return zipCommandLineArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray) throws CommandErrorException, IOException {
        ZipCommandLineArguments zipCommandLineArguments = this.parseCommandLine(stringArray);
        long l = System.currentTimeMillis();
        File file = zipCommandLineArguments.getTargetFile();
        if (!file.createNewFile()) {
            throw new CommandErrorException("Could not create target file " + file);
        }
        ReadWritableFileAdapter readWritableFileAdapter = new ReadWritableFileAdapter(file);
        ZipBuilder zipBuilder = new ZipBuilder((RandomlyAccessibleFile)readWritableFileAdapter);
        try {
            for (File file2 : zipCommandLineArguments.getFilesToZip()) {
                AbsoluteLocation absoluteLocation = this.getParentLocation(file2);
                if (zipCommandLineArguments.isRecursive()) {
                    zipBuilder.addRecursively(file2, absoluteLocation.getChildLocation(file2.getName()));
                    continue;
                }
                zipBuilder.add(file2, absoluteLocation);
            }
        }
        finally {
            zipBuilder.close();
        }
        long l2 = System.currentTimeMillis();
        if (zipCommandLineArguments.isTiming()) {
            System.out.println("The operation took " + (l2 - l) + " ms.");
            System.out.println("The time it took to load Java and start the program is not included.");
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Zip().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

