/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.zip.prog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.at4j.support.prog.CommandErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ZipCommandLineArguments {
    private boolean m_recursive;
    private boolean m_timing;
    private File m_targetFile;
    private final List<File> m_filesToZip = new ArrayList<File>();

    ZipCommandLineArguments() {
    }

    void setRecursive() {
        this.m_recursive = true;
    }

    boolean isRecursive() {
        return this.m_recursive;
    }

    void setTargetFile(File file) throws CommandErrorException {
        if (file.exists()) {
            throw new CommandErrorException(file + " already exists");
        }
        this.m_targetFile = file;
    }

    File getTargetFile() {
        return this.m_targetFile;
    }

    void addFileToZip(File file) throws CommandErrorException {
        if (!file.exists()) {
            throw new CommandErrorException(file + " does not exist");
        }
        this.m_filesToZip.add(file);
    }

    List<File> getFilesToZip() {
        return this.m_filesToZip;
    }

    void setTiming() {
        this.m_timing = true;
    }

    boolean isTiming() {
        return this.m_timing;
    }
}

