#include <config.h>
#include "inttostr.h"
#include "verify.h"
char * __attribute_warn_unused_result__
anytostr (inttype i, char *buf)
{
  verify (TYPE_SIGNED (inttype) == inttype_is_signed);
  char *p = buf + INT_STRLEN_BOUND (inttype);
  *p = 0;
#if inttype_is_signed
  if (i < 0)
    {
      do
        *--p = '0' - i % 10;
      while ((i /= 10) != 0);
      *--p = '-';
    }
  else
#endif
    {
      do
        *--p = '0' + i % 10;
      while ((i /= 10) != 0);
    }
  return p;
}
