#ifndef _GL_BITROTATE_H
#define _GL_BITROTATE_H
#include <limits.h>
#include <stdint.h>
#include <sys/types.h>
#ifdef UINT64_MAX
static inline uint64_t
rotl64 (uint64_t x, int n)
{
  return ((x << n) | (x >> (64 - n))) & UINT64_MAX;
}
static inline uint64_t
rotr64 (uint64_t x, int n)
{
  return ((x >> n) | (x << (64 - n))) & UINT64_MAX;
}
#endif
static inline uint32_t
rotl32 (uint32_t x, int n)
{
  return ((x << n) | (x >> (32 - n))) & UINT32_MAX;
}
static inline uint32_t
rotr32 (uint32_t x, int n)
{
  return ((x >> n) | (x << (32 - n))) & UINT32_MAX;
}
static inline size_t
rotl_sz (size_t x, int n)
{
  return ((x << n) | (x >> ((CHAR_BIT * sizeof x) - n))) & SIZE_MAX;
}
static inline size_t
rotr_sz (size_t x, int n)
{
  return ((x >> n) | (x << ((CHAR_BIT * sizeof x) - n))) & SIZE_MAX;
}
static inline uint16_t
rotl16 (uint16_t x, int n)
{
  return ((x << n) | (x >> (16 - n))) & UINT16_MAX;
}
static inline uint16_t
rotr16 (uint16_t x, int n)
{
  return ((x >> n) | (x << (16 - n))) & UINT16_MAX;
}
static inline uint8_t
rotl8 (uint8_t x, int n)
{
  return ((x << n) | (x >> (8 - n))) & UINT8_MAX;
}
static inline uint8_t
rotr8 (uint8_t x, int n)
{
  return ((x >> n) | (x << (8 - n))) & UINT8_MAX;
}
#endif 
