#include <config.h>
#include "search.h"
#include "dfa.h"
#define WCHAR(C) (isalnum (C) || (C) == '_')
static kwset_t kwset;
static struct dfa *dfa;
static struct patterns
{
  struct re_pattern_buffer regexbuf;
  struct re_registers regs; 
} patterns0;
static struct patterns *patterns;
static size_t pcount;
void
dfaerror (char const *mesg)
{
  error (EXIT_TROUBLE, 0, "%s", mesg);
  abort ();
}
void
dfawarn (char const *mesg)
{
  static enum { NONE = 0, POSIX, GNU } mode;
  if (mode == NONE)
    mode = (getenv ("POSIXLY_CORRECT") ? POSIX : GNU);
  if (mode == GNU)
    dfaerror (mesg);
}
static int kwset_exact_matches;
static char const *
kwsincr_case (const char *must)
{
  const char *buf;
  size_t n;
  n = strlen (must);
#if MBS_SUPPORT
  if (match_icase && MB_CUR_MAX > 1)
    buf = mbtolower (must, &n);
  else
#endif
    buf = must;
  return kwsincr (kwset, buf, n);
}
static void
kwsmusts (void)
{
  struct dfamust const *dm;
  char const *err;
  dm = dfamusts (dfa);
  if (dm)
    {
      kwsinit (&kwset);
      for (; dm; dm = dm->next)
        {
          if (!dm->exact)
            continue;
          ++kwset_exact_matches;
          if ((err = kwsincr_case (dm->must)) != NULL)
            error (EXIT_TROUBLE, 0, "%s", err);
        }
      for (dm = dfamusts (dfa); dm; dm = dm->next)
        {
          if (dm->exact)
            continue;
          if ((err = kwsincr_case (dm->must)) != NULL)
            error (EXIT_TROUBLE, 0, "%s", err);
        }
      if ((err = kwsprep (kwset)) != NULL)
        error (EXIT_TROUBLE, 0, "%s", err);
    }
}
void
GEAcompile (char const *pattern, size_t size, reg_syntax_t syntax_bits)
{
  const char *err;
  const char *p, *sep;
  size_t total = size;
  char *motif;
  if (match_icase)
    syntax_bits |= RE_ICASE;
  re_set_syntax (syntax_bits);
  dfasyntax (syntax_bits, match_icase, eolbyte);
  p = pattern;
  do
    {
      size_t len;
      sep = memchr (p, '\n', total);
      if (sep)
        {
          len = sep - p;
          sep++;
          total -= (len + 1);
        }
      else
        {
          len = total;
          total = 0;
        }
      patterns = realloc (patterns, (pcount + 1) * sizeof (*patterns));
      if (patterns == NULL)
        error (EXIT_TROUBLE, errno, _("memory exhausted"));
      patterns[pcount] = patterns0;
      if ((err = re_compile_pattern (p, len,
                                    &(patterns[pcount].regexbuf))) != NULL)
        error (EXIT_TROUBLE, 0, "%s", err);
      pcount++;
      p = sep;
    } while (sep && total != 0);
  if (match_words || match_lines)
    {
      static char const line_beg_no_bk[] = "^(";
      static char const line_end_no_bk[] = ")$";
      static char const word_beg_no_bk[] = "(^|[^[:alnum:]_])(";
      static char const word_end_no_bk[] = ")([^[:alnum:]_]|$)";
      static char const line_beg_bk[] = "^\\(";
      static char const line_end_bk[] = "\\)$";
      static char const word_beg_bk[] = "\\(^\\|[^[:alnum:]_]\\)\\(";
      static char const word_end_bk[] = "\\)\\([^[:alnum:]_]\\|$\\)";
      int bk = !(syntax_bits & RE_NO_BK_PARENS);
      char *n = xmalloc (sizeof word_beg_bk - 1 + size + sizeof word_end_bk);
      strcpy (n, match_lines ? (bk ? line_beg_bk : line_beg_no_bk)
                             : (bk ? word_beg_bk : word_beg_no_bk));
      total = strlen(n);
      memcpy (n + total, pattern, size);
      total += size;
      strcpy (n + total, match_lines ? (bk ? line_end_bk : line_end_no_bk)
                                     : (bk ? word_end_bk : word_end_no_bk));
      total += strlen (n + total);
      pattern = motif = n;
      size = total;
    }
  else
    motif = NULL;
  dfa = dfaalloc ();
  dfacomp (pattern, size, dfa, 1);
  kwsmusts ();
  free(motif);
}
size_t
EGexecute (char const *buf, size_t size, size_t *match_size,
           char const *start_ptr)
{
  char const *buflim, *beg, *end, *match, *best_match, *mb_start;
  char eol = eolbyte;
  int backref, start, len, best_len;
  struct kwsmatch kwsm;
  size_t i, ret_val;
#if MBS_SUPPORT
  if (MB_CUR_MAX > 1)
    {
      if (match_icase)
        {
          char *case_buf = mbtolower (buf, &size);
          if (start_ptr)
            start_ptr = case_buf + (start_ptr - buf);
          buf = case_buf;
        }
    }
#endif 
  mb_start = buf;
  buflim = buf + size;
  for (beg = end = buf; end < buflim; beg = end)
    {
      if (!start_ptr)
        {
          if (kwset)
            {
              size_t offset = kwsexec (kwset, beg, buflim - beg, &kwsm);
              if (offset == (size_t) -1)
                goto failure;
              beg += offset;
              if ((end = memchr(beg, eol, buflim - beg)) != NULL)
                end++;
              else
                end = buflim;
              match = beg;
              while (beg > buf && beg[-1] != eol)
                --beg;
              if (kwsm.index < kwset_exact_matches)
                {
#if MBS_SUPPORT
                  if (mb_start < beg)
                    mb_start = beg;
                  if (MB_CUR_MAX == 1
                      || !is_mb_middle (&mb_start, match, buflim,
                                        kwsm.size[0]))
#endif
                    goto success;
                }
              if (dfaexec (dfa, beg, (char *) end, 0, NULL, &backref) == NULL)
                continue;
            }
          else
            {
              char const *next_beg = dfaexec (dfa, beg, (char *) buflim,
                                              0, NULL, &backref);
              if (next_beg == NULL)
                break;
              beg = next_beg;
              if ((end = memchr(beg, eol, buflim - beg)) != NULL)
                end++;
              else
                end = buflim;
              while (beg > buf && beg[-1] != eol)
                --beg;
            }
          if (!backref)
            goto success;
        }
      else
        {
          beg = start_ptr;
          end = buflim;
        }
      best_match = end;
      best_len = 0;
      for (i = 0; i < pcount; i++)
        {
          patterns[i].regexbuf.not_eol = 0;
          if (0 <= (start = re_search (&(patterns[i].regexbuf),
                                       buf, end - buf - 1,
                                       beg - buf, end - beg - 1,
                                       &(patterns[i].regs))))
            {
              len = patterns[i].regs.end[0] - start;
              match = buf + start;
              if (match > best_match)
                continue;
              if (start_ptr && !match_words)
                goto assess_pattern_match;
              if ((!match_lines && !match_words)
                  || (match_lines && len == end - beg - 1))
                {
                  match = beg;
                  len = end - beg;
                  goto assess_pattern_match;
                }
              if (match_words)
                while (match <= best_match)
                  {
                    if ((match == buf || !WCHAR ((unsigned char) match[-1]))
                        && (start + len == end - buf - 1
                            || !WCHAR ((unsigned char) match[len])))
                      goto assess_pattern_match;
                    if (len > 0)
                      {
                        --len;
                        patterns[i].regexbuf.not_eol = 1;
                        len = re_match (&(patterns[i].regexbuf),
                                        buf, match + len - beg, match - buf,
                                        &(patterns[i].regs));
                      }
                    if (len <= 0)
                      {
                        if (match == end - 1)
                          break;
                        match++;
                        patterns[i].regexbuf.not_eol = 0;
                        start = re_search (&(patterns[i].regexbuf),
                                           buf, end - buf - 1,
                                           match - buf, end - match - 1,
                                           &(patterns[i].regs));
                        if (start < 0)
                          break;
                        len = patterns[i].regs.end[0] - start;
                        match = buf + start;
                      }
                  } 
              continue;
            assess_pattern_match:
              if (!start_ptr)
                {
                  goto success;
                }
              if (match < best_match || (match == best_match && len > best_len))
                {
                  best_match = match;
                  best_len = len;
                }
            } 
        } 
        if (best_match < end)
          {
            beg = best_match;
            len = best_len;
            goto success_in_len;
          }
    } 
 failure:
  ret_val = -1;
  goto out;
 success:
  len = end - beg;
 success_in_len:
  *match_size = len;
  ret_val = beg - buf;
 out:
  return ret_val;
}
