#include <config.h>
#include "hash-pjw.h"
#include <limits.h>
#define SIZE_BITS (sizeof (size_t) * CHAR_BIT)
size_t
hash_pjw (const void *x, size_t tablesize)
{
  const char *s;
  size_t h = 0;
  for (s = x; *s; s++)
    h = *s + ((h << 9) | (h >> (SIZE_BITS - 9)));
  return h % tablesize;
}
