#ifndef HASH_H_
# define HASH_H_
# include <stdio.h>
# include <stdbool.h>
# ifndef __attribute__
#  if __GNUC__ < 3 || (__GNUC__ == 3 && __GNUC_MINOR__ < 4)
#   define __attribute__(x)
#  endif
# endif
# ifndef ATTRIBUTE_WUR
#  define ATTRIBUTE_WUR __attribute__ ((__warn_unused_result__))
# endif
typedef size_t (*Hash_hasher) (const void *, size_t);
typedef bool (*Hash_comparator) (const void *, const void *);
typedef void (*Hash_data_freer) (void *);
typedef bool (*Hash_processor) (void *, void *);
struct hash_tuning
  {
    float shrink_threshold;     
    float shrink_factor;        
    float growth_threshold;     
    float growth_factor;        
    bool is_n_buckets;          
  };
typedef struct hash_tuning Hash_tuning;
struct hash_table;
typedef struct hash_table Hash_table;
size_t hash_get_n_buckets (const Hash_table *);
size_t hash_get_n_buckets_used (const Hash_table *);
size_t hash_get_n_entries (const Hash_table *);
size_t hash_get_max_bucket_length (const Hash_table *);
bool hash_table_ok (const Hash_table *);
void hash_print_statistics (const Hash_table *, FILE *);
void *hash_lookup (const Hash_table *, const void *);
void *hash_get_first (const Hash_table *);
void *hash_get_next (const Hash_table *, const void *);
size_t hash_get_entries (const Hash_table *, void **, size_t);
size_t hash_do_for_each (const Hash_table *, Hash_processor, void *);
size_t hash_string (const char *, size_t);
void hash_reset_tuning (Hash_tuning *);
Hash_table *hash_initialize (size_t, const Hash_tuning *,
                             Hash_hasher, Hash_comparator,
                             Hash_data_freer) ATTRIBUTE_WUR;
void hash_clear (Hash_table *);
void hash_free (Hash_table *);
bool hash_rehash (Hash_table *, size_t) ATTRIBUTE_WUR;
void *hash_insert (Hash_table *, const void *) ATTRIBUTE_WUR;
int hash_insert0 (Hash_table *table, const void *entry,
                  const void **matched_ent);
void *hash_delete (Hash_table *, const void *);
#endif
