#include <config.h>
#if !HAVE_LSTAT
typedef int dummy;
#else 
# define __need_system_sys_stat_h
# include <sys/types.h>
# include <sys/stat.h>
# undef __need_system_sys_stat_h
static inline int
orig_lstat (const char *filename, struct stat *buf)
{
  return lstat (filename, buf);
}
# include <sys/stat.h>
# include <string.h>
# include <errno.h>
int
rpl_lstat (const char *file, struct stat *sbuf)
{
  size_t len;
  int lstat_result = orig_lstat (file, sbuf);
  if (lstat_result != 0)
    return lstat_result;
  len = strlen (file);
  if (file[len - 1] != '/' || S_ISDIR (sbuf->st_mode))
    return 0;
  if (!S_ISLNK (sbuf->st_mode))
    {
      errno = ENOTDIR;
      return -1;
    }
  return stat (file, sbuf);
}
#endif 
