#include <config.h>
#ifdef malloc
# define NEED_MALLOC_GNU 1
# undef malloc
#elif GNULIB_MALLOC_GNU && !HAVE_MALLOC_GNU
# define NEED_MALLOC_GNU 1
#endif
#include <stdlib.h>
#include <errno.h>
#undef malloc
void *
rpl_malloc (size_t n)
{
  void *result;
#if NEED_MALLOC_GNU
  if (n == 0)
    n = 1;
#endif
  result = malloc (n);
#if !HAVE_MALLOC_POSIX
  if (result == NULL)
    errno = ENOMEM;
#endif
  return result;
}
