#include <config.h>
#include "malloca.h"
#undef malloc
#if HAVE_ALLOCA
#define MAGIC_NUMBER 0x1415fb4a
#define MAGIC_SIZE sizeof (int)
struct preliminary_header { void *next; char room[MAGIC_SIZE]; };
#define HEADER_SIZE \
  (((sizeof (struct preliminary_header) + sa_alignment_max - 1) / sa_alignment_max) * sa_alignment_max)
struct header { void *next; char room[HEADER_SIZE - sizeof (struct preliminary_header) + MAGIC_SIZE]; };
typedef int verify1[2 * (HEADER_SIZE == sizeof (struct header)) - 1];
#define HASH_TABLE_SIZE 257
static void * mmalloca_results[HASH_TABLE_SIZE];
#endif
void *
mmalloca (size_t n)
{
#if HAVE_ALLOCA
  size_t nplus = n + HEADER_SIZE;
  if (nplus >= n)
    {
      char *p = (char *) malloc (nplus);
      if (p != NULL)
        {
          size_t slot;
          p += HEADER_SIZE;
          ((int *) p)[-1] = MAGIC_NUMBER;
          slot = (unsigned long) p % HASH_TABLE_SIZE;
          ((struct header *) (p - HEADER_SIZE))->next = mmalloca_results[slot];
          mmalloca_results[slot] = p;
          return p;
        }
    }
  return NULL;
#else
# if !MALLOC_0_IS_NONNULL
  if (n == 0)
    n = 1;
# endif
  return malloc (n);
#endif
}
#if HAVE_ALLOCA
void
freea (void *p)
{
  if (p != NULL)
    {
      if (((int *) p)[-1] == MAGIC_NUMBER)
        {
          size_t slot = (unsigned long) p % HASH_TABLE_SIZE;
          void **chain = &mmalloca_results[slot];
          for (; *chain != NULL;)
            {
              if (*chain == p)
                {
                  char *p_begin = (char *) p - HEADER_SIZE;
                  *chain = ((struct header *) p_begin)->next;
                  free (p_begin);
                  return;
                }
              chain = &((struct header *) ((char *) *chain - HEADER_SIZE))->next;
            }
        }
    }
}
#endif
