#ifndef _MALLOCA_H
#define _MALLOCA_H
#include <alloca.h>
#include <stddef.h>
#include <stdlib.h>
#ifdef __cplusplus
extern "C" {
#endif
#if HAVE_ALLOCA
# define safe_alloca(N) ((N) < 4032 ? alloca (N) : NULL)
#else
# define safe_alloca(N) ((void) (N), NULL)
#endif
#if HAVE_ALLOCA
# define malloca(N) \
  ((N) < 4032 - sa_increment                                        \
   ? (void *) ((char *) alloca ((N) + sa_increment) + sa_increment) \
   : mmalloca (N))
#else
# define malloca(N) \
  mmalloca (N)
#endif
extern void * mmalloca (size_t n);
#if HAVE_ALLOCA
extern void freea (void *p);
#else
# define freea free
#endif
#if 1
# define nmalloca(n, s) \
    ((n) > (size_t) (sizeof (ptrdiff_t) <= sizeof (size_t) ? -1 : -2) / (s) \
     ? NULL \
     : malloca ((n) * (s)))
#else
extern void * nmalloca (size_t n, size_t s);
#endif
#ifdef __cplusplus
}
#endif
#if defined __GNUC__
# define sa_alignof __alignof__
#elif defined __cplusplus
  template <class type> struct sa_alignof_helper { char __slot1; type __slot2; };
# define sa_alignof(type) offsetof (sa_alignof_helper<type>, __slot2)
#elif defined __hpux
# define sa_alignof(type) (sizeof (type) <= 4 ? 4 : 8)
#elif defined _AIX
# define sa_alignof(type) (sizeof (type) <= 4 ? 4 : 8)
#else
# define sa_alignof(type) offsetof (struct { char __slot1; type __slot2; }, __slot2)
#endif
enum
{
  sa_alignment_long = sa_alignof (long),
  sa_alignment_double = sa_alignof (double),
#if HAVE_LONG_LONG_INT
  sa_alignment_longlong = sa_alignof (long long),
#endif
  sa_alignment_longdouble = sa_alignof (long double),
  sa_alignment_max = ((sa_alignment_long - 1) | (sa_alignment_double - 1)
#if HAVE_LONG_LONG_INT
                      | (sa_alignment_longlong - 1)
#endif
                      | (sa_alignment_longdouble - 1)
                     ) + 1,
  sa_increment = ((sizeof (int) + sa_alignment_max - 1) / sa_alignment_max) * sa_alignment_max
};
#endif 
