#ifndef _MBITER_H
#define _MBITER_H 1
#include <assert.h>
#include <stdbool.h>
#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <wchar.h>
#include "mbchar.h"
struct mbiter_multi
{
  const char *limit;    
  bool in_shift;        
  mbstate_t state;      
  bool next_done;       
  struct mbchar cur;    
};
static inline void
mbiter_multi_next (struct mbiter_multi *iter)
{
  if (iter->next_done)
    return;
  if (iter->in_shift)
    goto with_shift;
  if (is_basic (*iter->cur.ptr))
    {
      iter->cur.bytes = 1;
      iter->cur.wc = *iter->cur.ptr;
      iter->cur.wc_valid = true;
    }
  else
    {
      assert (mbsinit (&iter->state));
      iter->in_shift = true;
    with_shift:
      iter->cur.bytes = mbrtowc (&iter->cur.wc, iter->cur.ptr,
                                 iter->limit - iter->cur.ptr, &iter->state);
      if (iter->cur.bytes == (size_t) -1)
        {
          iter->cur.bytes = 1;
          iter->cur.wc_valid = false;
        }
      else if (iter->cur.bytes == (size_t) -2)
        {
          iter->cur.bytes = iter->limit - iter->cur.ptr;
          iter->cur.wc_valid = false;
        }
      else
        {
          if (iter->cur.bytes == 0)
            {
              iter->cur.bytes = 1;
              assert (*iter->cur.ptr == '\0');
              assert (iter->cur.wc == 0);
            }
          iter->cur.wc_valid = true;
          if (mbsinit (&iter->state))
            iter->in_shift = false;
        }
    }
  iter->next_done = true;
}
static inline void
mbiter_multi_reloc (struct mbiter_multi *iter, ptrdiff_t ptrdiff)
{
  iter->cur.ptr += ptrdiff;
  iter->limit += ptrdiff;
}
static inline void
mbiter_multi_copy (struct mbiter_multi *new_iter, const struct mbiter_multi *old_iter)
{
  new_iter->limit = old_iter->limit;
  if ((new_iter->in_shift = old_iter->in_shift))
    memcpy (&new_iter->state, &old_iter->state, sizeof (mbstate_t));
  else
    memset (&new_iter->state, 0, sizeof (mbstate_t));
  new_iter->next_done = old_iter->next_done;
  mb_copy (&new_iter->cur, &old_iter->cur);
}
typedef struct mbiter_multi mbi_iterator_t;
#define mbi_init(iter, startptr, length) \
  ((iter).cur.ptr = (startptr), (iter).limit = (iter).cur.ptr + (length), \
   (iter).in_shift = false, memset (&(iter).state, '\0', sizeof (mbstate_t)), \
   (iter).next_done = false)
#define mbi_avail(iter) \
  ((iter).cur.ptr < (iter).limit && (mbiter_multi_next (&(iter)), true))
#define mbi_advance(iter) \
  ((iter).cur.ptr += (iter).cur.bytes, (iter).next_done = false)
#define mbi_cur(iter) (iter).cur
#define mbi_cur_ptr(iter) (iter).cur.ptr
#define mbi_reloc(iter, ptrdiff) mbiter_multi_reloc (&iter, ptrdiff)
#define mbi_copy mbiter_multi_copy
#endif 
