#include <config.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include "mbuiter.h"
#define TOLOWER(Ch) (isupper (Ch) ? tolower (Ch) : (Ch))
int
mbscasecmp (const char *s1, const char *s2)
{
  if (s1 == s2)
    return 0;
  if (MB_CUR_MAX > 1)
    {
      mbui_iterator_t iter1;
      mbui_iterator_t iter2;
      mbui_init (iter1, s1);
      mbui_init (iter2, s2);
      while (mbui_avail (iter1) && mbui_avail (iter2))
        {
          int cmp = mb_casecmp (mbui_cur (iter1), mbui_cur (iter2));
          if (cmp != 0)
            return cmp;
          mbui_advance (iter1);
          mbui_advance (iter2);
        }
      if (mbui_avail (iter1))
        return 1;
      if (mbui_avail (iter2))
        return -1;
      return 0;
    }
  else
    {
      const unsigned char *p1 = (const unsigned char *) s1;
      const unsigned char *p2 = (const unsigned char *) s2;
      unsigned char c1, c2;
      do
        {
          c1 = TOLOWER (*p1);
          c2 = TOLOWER (*p2);
          if (c1 == '\0')
            break;
          ++p1;
          ++p2;
        }
      while (c1 == c2);
      if (UCHAR_MAX <= INT_MAX)
        return c1 - c2;
      else
        return (c1 > c2 ? 1 : c1 < c2 ? -1 : 0);
    }
}
