#include <config.h>
#include <langinfo.h>
#if REPLACE_NL_LANGINFO
# include <locale.h>
# include <string.h>
# undef nl_langinfo
char *
rpl_nl_langinfo (nl_item item)
{
  switch (item)
    {
# if GNULIB_defined_CODESET
    case CODESET:
      {
        const char *locale;
        static char buf[2 + 10 + 1];
        locale = setlocale (LC_CTYPE, NULL);
        if (locale != NULL && locale[0] != '\0')
          {
            const char *dot = strchr (locale, '.');
            if (dot != NULL)
              {
                const char *modifier;
                dot++;
                modifier = strchr (dot, '@');
                if (modifier == NULL)
                  return dot;
                if (modifier - dot < sizeof (buf))
                  {
                    memcpy (buf, dot, modifier - dot);
                    buf [modifier - dot] = '\0';
                    return buf;
                  }
              }
          }
        return "";
      }
# endif
# if GNULIB_defined_T_FMT_AMPM
    case T_FMT_AMPM:
      return "%I:%M:%S %p";
# endif
# if GNULIB_defined_ERA
    case ERA:
      return "";
    case ERA_D_FMT:
      item = D_FMT;
      break;
    case ERA_D_T_FMT:
      item = D_T_FMT;
      break;
    case ERA_T_FMT:
      item = T_FMT;
      break;
    case ALT_DIGITS:
      return "\0\0\0\0\0\0\0\0\0\0";
# endif
# if GNULIB_defined_YESEXPR
    case YESEXPR:
      return "^[yY]";
    case NOEXPR:
      return "^[nN]";
# endif
    default:
      break;
    }
  return nl_langinfo (item);
}
#else
# if (defined _WIN32 || defined __WIN32__) && ! defined __CYGWIN__
#  define WIN32_LEAN_AND_MEAN  
#  include <windows.h>
#  include <stdio.h>
# else
# endif
# include <locale.h>
char *
nl_langinfo (nl_item item)
{
  switch (item)
    {
    case CODESET:
# if (defined _WIN32 || defined __WIN32__) && ! defined __CYGWIN__
      {
        static char buf[2 + 10 + 1];
        sprintf (buf, "CP%u", GetACP ());
        return buf;
      }
# elif defined __BEOS__
      return "UTF-8";
# else
      return "ISO-8859-1";
# endif
    case RADIXCHAR:
      return localeconv () ->decimal_point;
    case THOUSEP:
      return localeconv () ->thousands_sep;
    case D_T_FMT:
    case ERA_D_T_FMT:
      return "%a %b %e %H:%M:%S %Y";
    case D_FMT:
    case ERA_D_FMT:
      return "%m/%d/%y";
    case T_FMT:
    case ERA_T_FMT:
      return "%H:%M:%S";
    case T_FMT_AMPM:
      return "%I:%M:%S %p";
    case AM_STR:
      return "AM";
    case PM_STR:
      return "PM";
    case DAY_1:
      return "Sunday";
    case DAY_2:
      return "Monday";
    case DAY_3:
      return "Tuesday";
    case DAY_4:
      return "Wednesday";
    case DAY_5:
      return "Thursday";
    case DAY_6:
      return "Friday";
    case DAY_7:
      return "Saturday";
    case ABDAY_1:
      return "Sun";
    case ABDAY_2:
      return "Mon";
    case ABDAY_3:
      return "Tue";
    case ABDAY_4:
      return "Wed";
    case ABDAY_5:
      return "Thu";
    case ABDAY_6:
      return "Fri";
    case ABDAY_7:
      return "Sat";
    case MON_1:
      return "January";
    case MON_2:
      return "February";
    case MON_3:
      return "March";
    case MON_4:
      return "April";
    case MON_5:
      return "May";
    case MON_6:
      return "June";
    case MON_7:
      return "July";
    case MON_8:
      return "August";
    case MON_9:
      return "September";
    case MON_10:
      return "October";
    case MON_11:
      return "November";
    case MON_12:
      return "December";
    case ABMON_1:
      return "Jan";
    case ABMON_2:
      return "Feb";
    case ABMON_3:
      return "Mar";
    case ABMON_4:
      return "Apr";
    case ABMON_5:
      return "May";
    case ABMON_6:
      return "Jun";
    case ABMON_7:
      return "Jul";
    case ABMON_8:
      return "Aug";
    case ABMON_9:
      return "Sep";
    case ABMON_10:
      return "Oct";
    case ABMON_11:
      return "Nov";
    case ABMON_12:
      return "Dec";
    case ERA:
      return "";
    case ALT_DIGITS:
      return "\0\0\0\0\0\0\0\0\0\0";
    case CRNCYSTR:
      return "-";
    case YESEXPR:
      return "^[yY]";
    case NOEXPR:
      return "^[nN]";
    default:
      return "";
    }
}
#endif
