#ifdef _LIBC
# include <obstack.h>
# include <shlib-compat.h>
#else
# include <config.h>
# include "obstack.h"
#endif
#define OBSTACK_INTERFACE_VERSION 1
#include <stdio.h>              
#if !defined _LIBC && defined __GNU_LIBRARY__ && __GNU_LIBRARY__ > 1
# include <gnu-versions.h>
# if _GNU_OBSTACK_INTERFACE_VERSION == OBSTACK_INTERFACE_VERSION
#  define ELIDE_CODE
# endif
#endif
#include <stddef.h>
#ifndef ELIDE_CODE
# include <stdint.h>
union fooround
{
  uintmax_t i;
  long double d;
  void *p;
};
struct fooalign
{
  char c;
  union fooround u;
};
enum
  {
    DEFAULT_ALIGNMENT = offsetof (struct fooalign, u),
    DEFAULT_ROUNDING = sizeof (union fooround)
  };
# ifndef COPYING_UNIT
#  define COPYING_UNIT int
# endif
static void print_and_abort (void);
void (*obstack_alloc_failed_handler) (void) = print_and_abort;
# include <stdlib.h>
# ifdef _LIBC
int obstack_exit_failure = EXIT_FAILURE;
# else
#  include "exitfail.h"
#  define obstack_exit_failure exit_failure
# endif
# ifdef _LIBC
#  if SHLIB_COMPAT (libc, GLIBC_2_0, GLIBC_2_3_4)
struct obstack *_obstack_compat;
compat_symbol (libc, _obstack_compat, _obstack, GLIBC_2_0);
#  endif
# endif
# define CALL_CHUNKFUN(h, size) \
  (((h) -> use_extra_arg) \
   ? (*(h)->chunkfun) ((h)->extra_arg, (size)) \
   : (*(struct _obstack_chunk *(*) (long)) (h)->chunkfun) ((size)))
# define CALL_FREEFUN(h, old_chunk) \
  do { \
    if ((h) -> use_extra_arg) \
      (*(h)->freefun) ((h)->extra_arg, (old_chunk)); \
    else \
      (*(void (*) (void *)) (h)->freefun) ((old_chunk)); \
  } while (0)
int
_obstack_begin (struct obstack *h,
                int size, int alignment,
                void *(*chunkfun) (long),
                void (*freefun) (void *))
{
  register struct _obstack_chunk *chunk; 
  if (alignment == 0)
    alignment = DEFAULT_ALIGNMENT;
  if (size == 0)
    {
      int extra = ((((12 + DEFAULT_ROUNDING - 1) & ~(DEFAULT_ROUNDING - 1))
                    + 4 + DEFAULT_ROUNDING - 1)
                   & ~(DEFAULT_ROUNDING - 1));
      size = 4096 - extra;
    }
  h->chunkfun = (struct _obstack_chunk * (*)(void *, long)) chunkfun;
  h->freefun = (void (*) (void *, struct _obstack_chunk *)) freefun;
  h->chunk_size = size;
  h->alignment_mask = alignment - 1;
  h->use_extra_arg = 0;
  chunk = h->chunk = CALL_CHUNKFUN (h, h -> chunk_size);
  if (!chunk)
    (*obstack_alloc_failed_handler) ();
  h->next_free = h->object_base = __PTR_ALIGN ((char *) chunk, chunk->contents,
                                               alignment - 1);
  h->chunk_limit = chunk->limit
    = (char *) chunk + h->chunk_size;
  chunk->prev = 0;
  h->maybe_empty_object = 0;
  h->alloc_failed = 0;
  return 1;
}
int
_obstack_begin_1 (struct obstack *h, int size, int alignment,
                  void *(*chunkfun) (void *, long),
                  void (*freefun) (void *, void *),
                  void *arg)
{
  register struct _obstack_chunk *chunk; 
  if (alignment == 0)
    alignment = DEFAULT_ALIGNMENT;
  if (size == 0)
    {
      int extra = ((((12 + DEFAULT_ROUNDING - 1) & ~(DEFAULT_ROUNDING - 1))
                    + 4 + DEFAULT_ROUNDING - 1)
                   & ~(DEFAULT_ROUNDING - 1));
      size = 4096 - extra;
    }
  h->chunkfun = (struct _obstack_chunk * (*)(void *,long)) chunkfun;
  h->freefun = (void (*) (void *, struct _obstack_chunk *)) freefun;
  h->chunk_size = size;
  h->alignment_mask = alignment - 1;
  h->extra_arg = arg;
  h->use_extra_arg = 1;
  chunk = h->chunk = CALL_CHUNKFUN (h, h -> chunk_size);
  if (!chunk)
    (*obstack_alloc_failed_handler) ();
  h->next_free = h->object_base = __PTR_ALIGN ((char *) chunk, chunk->contents,
                                               alignment - 1);
  h->chunk_limit = chunk->limit
    = (char *) chunk + h->chunk_size;
  chunk->prev = 0;
  h->maybe_empty_object = 0;
  h->alloc_failed = 0;
  return 1;
}
void
_obstack_newchunk (struct obstack *h, int length)
{
  register struct _obstack_chunk *old_chunk = h->chunk;
  register struct _obstack_chunk *new_chunk;
  register long new_size;
  register long obj_size = h->next_free - h->object_base;
  register long i;
  long already;
  char *object_base;
  new_size = (obj_size + length) + (obj_size >> 3) + h->alignment_mask + 100;
  if (new_size < h->chunk_size)
    new_size = h->chunk_size;
  new_chunk = CALL_CHUNKFUN (h, new_size);
  if (!new_chunk)
    (*obstack_alloc_failed_handler) ();
  h->chunk = new_chunk;
  new_chunk->prev = old_chunk;
  new_chunk->limit = h->chunk_limit = (char *) new_chunk + new_size;
  object_base =
    __PTR_ALIGN ((char *) new_chunk, new_chunk->contents, h->alignment_mask);
  if (h->alignment_mask + 1 >= DEFAULT_ALIGNMENT)
    {
      for (i = obj_size / sizeof (COPYING_UNIT) - 1;
           i >= 0; i--)
        ((COPYING_UNIT *)object_base)[i]
          = ((COPYING_UNIT *)h->object_base)[i];
      already = obj_size / sizeof (COPYING_UNIT) * sizeof (COPYING_UNIT);
    }
  else
    already = 0;
  for (i = already; i < obj_size; i++)
    object_base[i] = h->object_base[i];
  if (! h->maybe_empty_object
      && (h->object_base
          == __PTR_ALIGN ((char *) old_chunk, old_chunk->contents,
                          h->alignment_mask)))
    {
      new_chunk->prev = old_chunk->prev;
      CALL_FREEFUN (h, old_chunk);
    }
  h->object_base = object_base;
  h->next_free = h->object_base + obj_size;
  h->maybe_empty_object = 0;
}
# ifdef _LIBC
libc_hidden_def (_obstack_newchunk)
# endif
int _obstack_allocated_p (struct obstack *h, void *obj);
int
_obstack_allocated_p (struct obstack *h, void *obj)
{
  register struct _obstack_chunk *lp;   
  register struct _obstack_chunk *plp;  
  lp = (h)->chunk;
  while (lp != 0 && ((void *) lp >= obj || (void *) (lp)->limit < obj))
    {
      plp = lp->prev;
      lp = plp;
    }
  return lp != 0;
}
# undef obstack_free
void
__obstack_free (struct obstack *h, void *obj)
{
  register struct _obstack_chunk *lp;   
  register struct _obstack_chunk *plp;  
  lp = h->chunk;
  while (lp != 0 && ((void *) lp >= obj || (void *) (lp)->limit < obj))
    {
      plp = lp->prev;
      CALL_FREEFUN (h, lp);
      lp = plp;
      h->maybe_empty_object = 1;
    }
  if (lp)
    {
      h->object_base = h->next_free = (char *) (obj);
      h->chunk_limit = lp->limit;
      h->chunk = lp;
    }
  else if (obj != 0)
    abort ();
}
# ifdef _LIBC
strong_alias (obstack_free, _obstack_free)
# endif
int
_obstack_memory_used (struct obstack *h)
{
  register struct _obstack_chunk* lp;
  register int nbytes = 0;
  for (lp = h->chunk; lp != 0; lp = lp->prev)
    {
      nbytes += lp->limit - (char *) lp;
    }
  return nbytes;
}
# ifdef _LIBC
#  include <libintl.h>
# else
#  include "gettext.h"
# endif
# ifndef _
#  define _(msgid) gettext (msgid)
# endif
# ifdef _LIBC
#  include <libio/iolibio.h>
# endif
# ifndef __attribute__
#  if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 5)
#   define __attribute__(Spec) 
#  endif
# endif
static void
__attribute__ ((noreturn))
print_and_abort (void)
{
# ifdef _LIBC
  (void) __fxprintf (NULL, "%s\n", _("memory exhausted"));
# else
  fprintf (stderr, "%s\n", _("memory exhausted"));
# endif
  exit (obstack_exit_failure);
}
#endif  
