#include <config.h>
#define __need_system_fcntl_h
#include <fcntl.h>
#undef __need_system_fcntl_h
#include <sys/types.h>
static inline int
orig_open (const char *filename, int flags, mode_t mode)
{
  return open (filename, flags, mode);
}
#include <fcntl.h>
#include <errno.h>
#include <stdarg.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#ifndef REPLACE_OPEN_DIRECTORY
# define REPLACE_OPEN_DIRECTORY 0
#endif
int
open (const char *filename, int flags, ...)
{
  mode_t mode;
  int fd;
  mode = 0;
  if (flags & O_CREAT)
    {
      va_list arg;
      va_start (arg, flags);
      mode = va_arg (arg, PROMOTED_MODE_T);
      va_end (arg);
    }
#if (defined _WIN32 || defined __WIN32__) && ! defined __CYGWIN__
  if (strcmp (filename, "/dev/null") == 0)
    filename = "NUL";
#endif
#if OPEN_TRAILING_SLASH_BUG
  if (flags & (O_CREAT | O_WRONLY | O_RDWR))
    {
      size_t len = strlen (filename);
      if (len > 0 && filename[len - 1] == '/')
        {
          errno = EISDIR;
          return -1;
        }
    }
#endif
  fd = orig_open (filename, flags, mode);
#if REPLACE_FCHDIR
  if (REPLACE_OPEN_DIRECTORY && fd < 0 && errno == EACCES
      && ((flags & O_ACCMODE) == O_RDONLY
          || (O_SEARCH != O_RDONLY && (flags & O_ACCMODE) == O_SEARCH)))
    {
      struct stat statbuf;
      if (stat (filename, &statbuf) == 0 && S_ISDIR (statbuf.st_mode))
        {
          fd = open ("/dev/null", flags, mode);
          if (0 <= fd)
            fd = _gl_register_fd (fd, filename);
        }
      else
        errno = EACCES;
    }
#endif
#if OPEN_TRAILING_SLASH_BUG
  if (fd >= 0)
    {
      size_t len = strlen (filename);
      if (filename[len - 1] == '/')
        {
          struct stat statbuf;
          if (fstat (fd, &statbuf) >= 0 && !S_ISDIR (statbuf.st_mode))
            {
              close (fd);
              errno = ENOTDIR;
              return -1;
            }
        }
    }
#endif
#if REPLACE_FCHDIR
  if (!REPLACE_OPEN_DIRECTORY && 0 <= fd)
    fd = _gl_register_fd (fd, filename);
#endif
  return fd;
}
