#include <config.h>
#include "propername.h"
#include <ctype.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if HAVE_ICONV
# include <iconv.h>
#endif
#include "trim.h"
#include "mbchar.h"
#include "mbuiter.h"
#include "localcharset.h"
#include "c-strcase.h"
#include "xstriconv.h"
#include "xalloc.h"
#include "gettext.h"
static bool
mbsstr_trimmed_wordbounded (const char *string, const char *sub)
{
  char *tsub = trim (sub);
  bool found = false;
  for (; *string != '\0';)
    {
      const char *tsub_in_string = mbsstr (string, tsub);
      if (tsub_in_string == NULL)
        break;
      else
        {
          if (MB_CUR_MAX > 1)
            {
              mbui_iterator_t string_iter;
              bool word_boundary_before;
              bool word_boundary_after;
              mbui_init (string_iter, string);
              word_boundary_before = true;
              if (mbui_cur_ptr (string_iter) < tsub_in_string)
                {
                  mbchar_t last_char_before_tsub;
                  do
                    {
                      if (!mbui_avail (string_iter))
                        abort ();
                      last_char_before_tsub = mbui_cur (string_iter);
                      mbui_advance (string_iter);
                    }
                  while (mbui_cur_ptr (string_iter) < tsub_in_string);
                  if (mb_isalnum (last_char_before_tsub))
                    word_boundary_before = false;
                }
              mbui_init (string_iter, tsub_in_string);
              {
                mbui_iterator_t tsub_iter;
                for (mbui_init (tsub_iter, tsub);
                     mbui_avail (tsub_iter);
                     mbui_advance (tsub_iter))
                  {
                    if (!mbui_avail (string_iter))
                      abort ();
                    mbui_advance (string_iter);
                  }
              }
              word_boundary_after = true;
              if (mbui_avail (string_iter))
                {
                  mbchar_t first_char_after_tsub = mbui_cur (string_iter);
                  if (mb_isalnum (first_char_after_tsub))
                    word_boundary_after = false;
                }
              if (word_boundary_before && word_boundary_after)
                {
                  found = true;
                  break;
                }
              mbui_init (string_iter, tsub_in_string);
              if (!mbui_avail (string_iter))
                break;
              string = tsub_in_string + mb_len (mbui_cur (string_iter));
            }
          else
            {
              bool word_boundary_before;
              const char *p;
              bool word_boundary_after;
              word_boundary_before = true;
              if (string < tsub_in_string)
                if (isalnum ((unsigned char) tsub_in_string[-1]))
                  word_boundary_before = false;
              p = tsub_in_string + strlen (tsub);
              word_boundary_after = true;
              if (*p != '\0')
                if (isalnum ((unsigned char) *p))
                  word_boundary_after = false;
              if (word_boundary_before && word_boundary_after)
                {
                  found = true;
                  break;
                }
              if (*tsub_in_string == '\0')
                break;
              string = tsub_in_string + 1;
            }
        }
    }
  free (tsub);
  return found;
}
const char *
proper_name (const char *name)
{
  const char *translation = gettext (name);
  if (translation != name)
    {
      if (mbsstr_trimmed_wordbounded (translation, name))
        return translation;
      else
        {
          char *result =
            XNMALLOC (strlen (translation) + 2 + strlen (name) + 1 + 1, char);
          sprintf (result, "%s (%s)", translation, name);
          return result;
        }
    }
  else
    return name;
}
const char *
proper_name_utf8 (const char *name_ascii, const char *name_utf8)
{
  const char *translation = gettext (name_ascii);
  const char *locale_code = locale_charset ();
  char *alloc_name_converted = NULL;
  char *alloc_name_converted_translit = NULL;
  const char *name_converted = NULL;
  const char *name_converted_translit = NULL;
  const char *name;
  if (c_strcasecmp (locale_code, "UTF-8") != 0)
    {
#if HAVE_ICONV
      name_converted = alloc_name_converted =
        xstr_iconv (name_utf8, "UTF-8", locale_code);
# if (__GLIBC__ == 2 && __GLIBC_MINOR__ >= 2) || __GLIBC__ > 2 \
     || _LIBICONV_VERSION >= 0x0105
      {
        char *converted_translit;
        size_t len = strlen (locale_code);
        char *locale_code_translit = XNMALLOC (len + 10 + 1, char);
        memcpy (locale_code_translit, locale_code, len);
        memcpy (locale_code_translit + len, "//TRANSLIT", 10 + 1);
        converted_translit =
          xstr_iconv (name_utf8, "UTF-8", locale_code_translit);
        free (locale_code_translit);
        if (converted_translit != NULL)
          {
#  if !_LIBICONV_VERSION
            if (strchr (converted_translit, '?') != NULL)
              free (converted_translit);
            else
#  endif
              name_converted_translit = alloc_name_converted_translit =
                converted_translit;
          }
      }
# endif
#endif
    }
  else
    {
      name_converted = name_utf8;
      name_converted_translit = name_utf8;
    }
  name = (name_converted != NULL ? name_converted :
          name_converted_translit != NULL ? name_converted_translit :
          name_ascii);
  if (strcmp (translation, name_ascii) != 0)
    {
      if (mbsstr_trimmed_wordbounded (translation, name_ascii)
          || (name_converted != NULL
              && mbsstr_trimmed_wordbounded (translation, name_converted))
          || (name_converted_translit != NULL
              && mbsstr_trimmed_wordbounded (translation, name_converted_translit)))
        {
          if (alloc_name_converted != NULL)
            free (alloc_name_converted);
          if (alloc_name_converted_translit != NULL)
            free (alloc_name_converted_translit);
          return translation;
        }
      else
        {
          char *result =
            XNMALLOC (strlen (translation) + 2 + strlen (name) + 1 + 1, char);
          sprintf (result, "%s (%s)", translation, name);
          if (alloc_name_converted != NULL)
            free (alloc_name_converted);
          if (alloc_name_converted_translit != NULL)
            free (alloc_name_converted_translit);
          return result;
        }
    }
  else
    {
      if (alloc_name_converted != NULL && alloc_name_converted != name)
        free (alloc_name_converted);
      if (alloc_name_converted_translit != NULL
          && alloc_name_converted_translit != name)
        free (alloc_name_converted_translit);
      return name;
    }
}
#ifdef TEST1
# include <locale.h>
int
main (int argc, char *argv[])
{
  setlocale (LC_ALL, "");
  if (mbsstr_trimmed_wordbounded (argv[1], argv[2]))
    printf("found\n");
  return 0;
}
#endif
#ifdef TEST2
# include <locale.h>
# include <stdio.h>
int
main (int argc, char *argv[])
{
  setlocale (LC_ALL, "");
  printf ("%s\n", proper_name_utf8 ("Franc,ois Pinard", "Fran\303\247ois Pinard"));
  return 0;
}
#endif
