#include <config.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#ifndef __set_errno
# define __set_errno(ev) ((errno) = (ev))
#endif
#include <string.h>
#include <unistd.h>
#if HAVE_GNU_LD
# define environ __environ
#else
extern char **environ;
#endif
#if _LIBC
# include <bits/libc-lock.h>
__libc_lock_define_initialized (static, envlock)
# define LOCK   __libc_lock_lock (envlock)
# define UNLOCK __libc_lock_unlock (envlock)
#else
# define LOCK
# define UNLOCK
#endif
static int
_unsetenv (const char *name)
{
  size_t len;
  char **ep;
  if (name == NULL || *name == '\0' || strchr (name, '=') != NULL)
    {
      __set_errno (EINVAL);
      return -1;
    }
  len = strlen (name);
  LOCK;
  ep = environ;
  while (*ep != NULL)
    if (!strncmp (*ep, name, len) && (*ep)[len] == '=')
      {
        char **dp = ep;
        do
          dp[0] = dp[1];
        while (*dp++);
      }
    else
      ++ep;
  UNLOCK;
  return 0;
}
int
putenv (char *string)
{
  const char *const name_end = strchr (string, '=');
  register size_t size;
  register char **ep;
  if (name_end == NULL)
    {
      return _unsetenv (string);
    }
  size = 0;
  for (ep = environ; *ep != NULL; ++ep)
    if (!strncmp (*ep, string, name_end - string) &&
        (*ep)[name_end - string] == '=')
      break;
    else
      ++size;
  if (*ep == NULL)
    {
      static char **last_environ = NULL;
      char **new_environ = (char **) malloc ((size + 2) * sizeof (char *));
      if (new_environ == NULL)
        return -1;
      (void) memcpy ((void *) new_environ, (void *) environ,
                     size * sizeof (char *));
      new_environ[size] = (char *) string;
      new_environ[size + 1] = NULL;
      free (last_environ);
      last_environ = new_environ;
      environ = new_environ;
    }
  else
    *ep = string;
  return 0;
}
