#include <config.h>
#ifdef realloc
# define NEED_REALLOC_GNU 1
#elif GNULIB_REALLOC_GNU && !HAVE_REALLOC_GNU
# define NEED_REALLOC_GNU 1
#endif
#if GNULIB_MALLOC_GNU && HAVE_MALLOC_GNU
# define SYSTEM_MALLOC_GLIBC_COMPATIBLE 1
#endif
#undef malloc
#undef realloc
#include <stdlib.h>
#include <errno.h>
#undef malloc
#undef realloc
void *
rpl_realloc (void *p, size_t n)
{
  void *result;
#if NEED_REALLOC_GNU
  if (n == 0)
    {
      n = 1;
      free (p);
      p = NULL;
    }
#endif
  if (p == NULL)
    {
#if GNULIB_REALLOC_GNU && !NEED_REALLOC_GNU && !SYSTEM_MALLOC_GLIBC_COMPATIBLE
      if (n == 0)
        n = 1;
#endif
      result = malloc (n);
    }
  else
    result = realloc (p, n);
#if !HAVE_REALLOC_POSIX
  if (result == NULL)
    errno = ENOMEM;
#endif
  return result;
}
