#ifndef _REGEX_H
#define _REGEX_H 1
#include <sys/types.h>
#ifdef __cplusplus
extern "C" {
#endif
#undef __USE_GNU_REGEX
#if (defined _GNU_SOURCE					\
     || (!defined _POSIX_C_SOURCE && !defined _POSIX_SOURCE	\
	 && !defined _XOPEN_SOURCE))
# define __USE_GNU_REGEX 1
#endif
#ifdef _REGEX_LARGE_OFFSETS
typedef ssize_t regoff_t;
typedef size_t __re_idx_t;
typedef size_t __re_size_t;
typedef size_t __re_long_size_t;
#else
typedef int regoff_t;
typedef int __re_idx_t;
typedef unsigned int __re_size_t;
typedef unsigned long int __re_long_size_t;
#endif
typedef long int s_reg_t;
typedef unsigned long int active_reg_t;
typedef unsigned long int reg_syntax_t;
#ifdef __USE_GNU_REGEX
# define RE_BACKSLASH_ESCAPE_IN_LISTS ((unsigned long int) 1)
# define RE_BK_PLUS_QM (RE_BACKSLASH_ESCAPE_IN_LISTS << 1)
# define RE_CHAR_CLASSES (RE_BK_PLUS_QM << 1)
# define RE_CONTEXT_INDEP_ANCHORS (RE_CHAR_CLASSES << 1)
# define RE_CONTEXT_INDEP_OPS (RE_CONTEXT_INDEP_ANCHORS << 1)
# define RE_CONTEXT_INVALID_OPS (RE_CONTEXT_INDEP_OPS << 1)
# define RE_DOT_NEWLINE (RE_CONTEXT_INVALID_OPS << 1)
# define RE_DOT_NOT_NULL (RE_DOT_NEWLINE << 1)
# define RE_HAT_LISTS_NOT_NEWLINE (RE_DOT_NOT_NULL << 1)
# define RE_INTERVALS (RE_HAT_LISTS_NOT_NEWLINE << 1)
# define RE_LIMITED_OPS (RE_INTERVALS << 1)
# define RE_NEWLINE_ALT (RE_LIMITED_OPS << 1)
# define RE_NO_BK_BRACES (RE_NEWLINE_ALT << 1)
# define RE_NO_BK_PARENS (RE_NO_BK_BRACES << 1)
# define RE_NO_BK_REFS (RE_NO_BK_PARENS << 1)
# define RE_NO_BK_VBAR (RE_NO_BK_REFS << 1)
# define RE_NO_EMPTY_RANGES (RE_NO_BK_VBAR << 1)
# define RE_UNMATCHED_RIGHT_PAREN_ORD (RE_NO_EMPTY_RANGES << 1)
# define RE_NO_POSIX_BACKTRACKING (RE_UNMATCHED_RIGHT_PAREN_ORD << 1)
# define RE_NO_GNU_OPS (RE_NO_POSIX_BACKTRACKING << 1)
# define RE_DEBUG (RE_NO_GNU_OPS << 1)
# define RE_INVALID_INTERVAL_ORD (RE_DEBUG << 1)
# define RE_ICASE (RE_INVALID_INTERVAL_ORD << 1)
# define RE_CARET_ANCHORS_HERE (RE_ICASE << 1)
# define RE_CONTEXT_INVALID_DUP (RE_CARET_ANCHORS_HERE << 1)
# define RE_NO_SUB (RE_CONTEXT_INVALID_DUP << 1)
#endif 
extern reg_syntax_t re_syntax_options;
#ifdef __USE_GNU_REGEX
# define RE_SYNTAX_EMACS 0
# define RE_SYNTAX_AWK							\
  (RE_BACKSLASH_ESCAPE_IN_LISTS   | RE_DOT_NOT_NULL			\
   | RE_NO_BK_PARENS              | RE_NO_BK_REFS			\
   | RE_NO_BK_VBAR                | RE_NO_EMPTY_RANGES			\
   | RE_DOT_NEWLINE		  | RE_CONTEXT_INDEP_ANCHORS		\
   | RE_UNMATCHED_RIGHT_PAREN_ORD | RE_NO_GNU_OPS)
# define RE_SYNTAX_GNU_AWK						\
  ((RE_SYNTAX_POSIX_EXTENDED | RE_BACKSLASH_ESCAPE_IN_LISTS | RE_DEBUG)	\
   & ~(RE_DOT_NOT_NULL | RE_INTERVALS | RE_CONTEXT_INDEP_OPS		\
       | RE_CONTEXT_INVALID_OPS ))
# define RE_SYNTAX_POSIX_AWK						\
  (RE_SYNTAX_POSIX_EXTENDED | RE_BACKSLASH_ESCAPE_IN_LISTS		\
   | RE_INTERVALS	    | RE_NO_GNU_OPS)
# define RE_SYNTAX_GREP							\
  (RE_BK_PLUS_QM              | RE_CHAR_CLASSES				\
   | RE_HAT_LISTS_NOT_NEWLINE | RE_INTERVALS				\
   | RE_NEWLINE_ALT)
# define RE_SYNTAX_EGREP						\
  (RE_CHAR_CLASSES        | RE_CONTEXT_INDEP_ANCHORS			\
   | RE_CONTEXT_INDEP_OPS | RE_HAT_LISTS_NOT_NEWLINE			\
   | RE_NEWLINE_ALT       | RE_NO_BK_PARENS				\
   | RE_NO_BK_VBAR)
# define RE_SYNTAX_POSIX_EGREP						\
  (RE_SYNTAX_EGREP | RE_INTERVALS | RE_NO_BK_BRACES			\
   | RE_INVALID_INTERVAL_ORD)
# define RE_SYNTAX_ED RE_SYNTAX_POSIX_BASIC
# define RE_SYNTAX_SED RE_SYNTAX_POSIX_BASIC
# define _RE_SYNTAX_POSIX_COMMON					\
  (RE_CHAR_CLASSES | RE_DOT_NEWLINE      | RE_DOT_NOT_NULL		\
   | RE_INTERVALS  | RE_NO_EMPTY_RANGES)
# define RE_SYNTAX_POSIX_BASIC						\
  (_RE_SYNTAX_POSIX_COMMON | RE_BK_PLUS_QM | RE_CONTEXT_INVALID_DUP)
# define RE_SYNTAX_POSIX_MINIMAL_BASIC					\
  (_RE_SYNTAX_POSIX_COMMON | RE_LIMITED_OPS)
# define RE_SYNTAX_POSIX_EXTENDED					\
  (_RE_SYNTAX_POSIX_COMMON  | RE_CONTEXT_INDEP_ANCHORS			\
   | RE_CONTEXT_INDEP_OPS   | RE_NO_BK_BRACES				\
   | RE_NO_BK_PARENS        | RE_NO_BK_VBAR				\
   | RE_CONTEXT_INVALID_OPS | RE_UNMATCHED_RIGHT_PAREN_ORD)
# define RE_SYNTAX_POSIX_MINIMAL_EXTENDED				\
  (_RE_SYNTAX_POSIX_COMMON  | RE_CONTEXT_INDEP_ANCHORS			\
   | RE_CONTEXT_INVALID_OPS | RE_NO_BK_BRACES				\
   | RE_NO_BK_PARENS        | RE_NO_BK_REFS				\
   | RE_NO_BK_VBAR	    | RE_UNMATCHED_RIGHT_PAREN_ORD)
#endif 
#ifdef __USE_GNU_REGEX
# ifdef RE_DUP_MAX
#  undef RE_DUP_MAX
# endif
# define RE_DUP_MAX (0x7fff)
#endif 
#define REG_EXTENDED 1
#define REG_ICASE (1 << 1)
#define REG_NEWLINE (1 << 2)
#define REG_NOSUB (1 << 3)
#define REG_NOTBOL 1
#define REG_NOTEOL (1 << 1)
#define REG_STARTEND (1 << 2)
typedef enum
{
  _REG_ENOSYS = -1,	
  _REG_NOERROR = 0,	
  _REG_NOMATCH,		
  _REG_BADPAT,		
  _REG_ECOLLATE,	
  _REG_ECTYPE,		
  _REG_EESCAPE,		
  _REG_ESUBREG,		
  _REG_EBRACK,		
  _REG_EPAREN,		
  _REG_EBRACE,		
  _REG_BADBR,		
  _REG_ERANGE,		
  _REG_ESPACE,		
  _REG_BADRPT,		
  _REG_EEND,		
  _REG_ESIZE,		
  _REG_ERPAREN		
} reg_errcode_t;
#ifdef _XOPEN_SOURCE
# define REG_ENOSYS	_REG_ENOSYS
#endif
#define REG_NOERROR	_REG_NOERROR
#define REG_NOMATCH	_REG_NOMATCH
#define REG_BADPAT	_REG_BADPAT
#define REG_ECOLLATE	_REG_ECOLLATE
#define REG_ECTYPE	_REG_ECTYPE
#define REG_EESCAPE	_REG_EESCAPE
#define REG_ESUBREG	_REG_ESUBREG
#define REG_EBRACK	_REG_EBRACK
#define REG_EPAREN	_REG_EPAREN
#define REG_EBRACE	_REG_EBRACE
#define REG_BADBR	_REG_BADBR
#define REG_ERANGE	_REG_ERANGE
#define REG_ESPACE	_REG_ESPACE
#define REG_BADRPT	_REG_BADRPT
#define REG_EEND	_REG_EEND
#define REG_ESIZE	_REG_ESIZE
#define REG_ERPAREN	_REG_ERPAREN
#ifdef __USE_GNU_REGEX
# define _REG_RE_NAME(id) id
# define _REG_RM_NAME(id) id
#else
# define _REG_RE_NAME(id) re_##id
# define _REG_RM_NAME(id) rm_##id
#endif
#ifdef __USE_GNU_REGEX
# ifndef RE_TRANSLATE_TYPE
#  define RE_TRANSLATE_TYPE unsigned char *
# endif
# define REG_TRANSLATE_TYPE RE_TRANSLATE_TYPE
#else
# define REG_TRANSLATE_TYPE unsigned char *
#endif
struct re_pattern_buffer
{
  unsigned char *_REG_RE_NAME (buffer);
  __re_long_size_t _REG_RE_NAME (allocated);
  __re_long_size_t _REG_RE_NAME (used);
  reg_syntax_t _REG_RE_NAME (syntax);
  char *_REG_RE_NAME (fastmap);
  REG_TRANSLATE_TYPE _REG_RE_NAME (translate);
  size_t re_nsub;
  unsigned int _REG_RE_NAME (can_be_null) : 1;
#ifdef __USE_GNU_REGEX
# define REGS_UNALLOCATED 0
# define REGS_REALLOCATE 1
# define REGS_FIXED 2
#endif
  unsigned int _REG_RE_NAME (regs_allocated) : 2;
  unsigned int _REG_RE_NAME (fastmap_accurate) : 1;
  unsigned int _REG_RE_NAME (no_sub) : 1;
  unsigned int _REG_RE_NAME (not_bol) : 1;
  unsigned int _REG_RE_NAME (not_eol) : 1;
  unsigned int _REG_RE_NAME (newline_anchor) : 1;
};
typedef struct re_pattern_buffer regex_t;
struct re_registers
{
  __re_size_t _REG_RM_NAME (num_regs);
  regoff_t *_REG_RM_NAME (start);
  regoff_t *_REG_RM_NAME (end);
};
#if !defined RE_NREGS && defined __USE_GNU_REGEX
# define RE_NREGS 30
#endif
typedef struct
{
  regoff_t rm_so;  
  regoff_t rm_eo;  
} regmatch_t;
extern reg_syntax_t re_set_syntax (reg_syntax_t __syntax);
extern const char *re_compile_pattern (const char *__pattern, size_t __length,
				       struct re_pattern_buffer *__buffer);
extern int re_compile_fastmap (struct re_pattern_buffer *__buffer);
extern regoff_t re_search (struct re_pattern_buffer *__buffer,
			   const char *__string, __re_idx_t __length,
			   __re_idx_t __start, regoff_t __range,
			   struct re_registers *__regs);
extern regoff_t re_search_2 (struct re_pattern_buffer *__buffer,
			     const char *__string1, __re_idx_t __length1,
			     const char *__string2, __re_idx_t __length2,
			     __re_idx_t __start, regoff_t __range,
			     struct re_registers *__regs,
			     __re_idx_t __stop);
extern regoff_t re_match (struct re_pattern_buffer *__buffer,
			  const char *__string, __re_idx_t __length,
			  __re_idx_t __start, struct re_registers *__regs);
extern regoff_t re_match_2 (struct re_pattern_buffer *__buffer,
			    const char *__string1, __re_idx_t __length1,
			    const char *__string2, __re_idx_t __length2,
			    __re_idx_t __start, struct re_registers *__regs,
			    __re_idx_t __stop);
extern void re_set_registers (struct re_pattern_buffer *__buffer,
			      struct re_registers *__regs,
			      __re_size_t __num_regs,
			      regoff_t *__starts, regoff_t *__ends);
#if defined _REGEX_RE_COMP || defined _LIBC
# ifndef _CRAY
extern char *re_comp (const char *);
extern int re_exec (const char *);
# endif
#endif
#ifndef _Restrict_
# if 199901L <= __STDC_VERSION__
#  define _Restrict_ restrict
# elif 2 < __GNUC__ || (2 == __GNUC__ && 95 <= __GNUC_MINOR__)
#  define _Restrict_ __restrict
# else
#  define _Restrict_
# endif
#endif
#ifndef _Restrict_arr_
# if ((199901L <= __STDC_VERSION__					\
       || ((3 < __GNUC__ || (3 == __GNUC__ && 1 <= __GNUC_MINOR__))	\
	   && !__STRICT_ANSI__))					\
      && !defined __GNUG__)
#  define _Restrict_arr_ _Restrict_
# else
#  define _Restrict_arr_
# endif
#endif
extern int regcomp (regex_t *_Restrict_ __preg,
		    const char *_Restrict_ __pattern,
		    int __cflags);
extern int regexec (const regex_t *_Restrict_ __preg,
		    const char *_Restrict_ __string, size_t __nmatch,
		    regmatch_t __pmatch[_Restrict_arr_],
		    int __eflags);
extern size_t regerror (int __errcode, const regex_t *_Restrict_ __preg,
			char *_Restrict_ __errbuf, size_t __errbuf_size);
extern void regfree (regex_t *__preg);
#ifdef __cplusplus
}
#endif	
#endif 
